/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.vpnservice.fibmanager;

import com.google.common.base.Optional;
import com.google.common.base.Preconditions;
import com.google.common.util.concurrent.FutureCallback;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import java.math.BigInteger;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import org.opendaylight.controller.md.sal.binding.api.DataBroker;
import org.opendaylight.controller.md.sal.binding.api.DataChangeListener;
import org.opendaylight.controller.md.sal.binding.api.ReadOnlyTransaction;
import org.opendaylight.controller.md.sal.binding.api.WriteTransaction;
import org.opendaylight.controller.md.sal.common.api.data.AsyncDataBroker;
import org.opendaylight.controller.md.sal.common.api.data.LogicalDatastoreType;
import org.opendaylight.vpnmanager.api.IVpnManager;
import org.opendaylight.vpnservice.AbstractDataChangeListener;
import org.opendaylight.vpnservice.mdsalutil.ActionInfo;
import org.opendaylight.vpnservice.mdsalutil.ActionType;
import org.opendaylight.vpnservice.mdsalutil.FlowEntity;
import org.opendaylight.vpnservice.mdsalutil.InstructionInfo;
import org.opendaylight.vpnservice.mdsalutil.InstructionType;
import org.opendaylight.vpnservice.mdsalutil.MDSALUtil;
import org.opendaylight.vpnservice.mdsalutil.MatchFieldType;
import org.opendaylight.vpnservice.mdsalutil.MatchInfo;
import org.opendaylight.vpnservice.mdsalutil.MetaDataUtil;
import org.opendaylight.vpnservice.mdsalutil.interfaces.IMdsalApiManager;
import org.opendaylight.yang.gen.v1.urn.huawei.params.xml.ns.yang.l3vpn.rev140815.VpnInstances;
import org.opendaylight.yang.gen.v1.urn.huawei.params.xml.ns.yang.l3vpn.rev140815.vpn.instances.VpnInstance;
import org.opendaylight.yang.gen.v1.urn.opendaylight.l3vpn.rev130911.VpnInstance1;
import org.opendaylight.yang.gen.v1.urn.opendaylight.vpnservice.fibmanager.rev150330.FibEntries;
import org.opendaylight.yang.gen.v1.urn.opendaylight.vpnservice.fibmanager.rev150330.fibentries.VrfTables;
import org.opendaylight.yang.gen.v1.urn.opendaylight.vpnservice.fibmanager.rev150330.fibentries.VrfTablesKey;
import org.opendaylight.yang.gen.v1.urn.opendaylight.vpnservice.fibmanager.rev150330.vrfentries.VrfEntry;
import org.opendaylight.yang.gen.v1.urn.opendaylight.vpnservice.l3nexthop.rev150409.GetEgressPointerInputBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.vpnservice.l3nexthop.rev150409.GetEgressPointerOutput;
import org.opendaylight.yang.gen.v1.urn.opendaylight.vpnservice.l3nexthop.rev150409.L3nexthopService;
import org.opendaylight.yang.gen.v1.urn.opendaylight.vpnservice.l3nexthop.rev150409.RemoveLocalNextHopInputBuilder;
import org.opendaylight.yangtools.concepts.ListenerRegistration;
import org.opendaylight.yangtools.yang.binding.DataObject;
import org.opendaylight.yangtools.yang.binding.Identifier;
import org.opendaylight.yangtools.yang.binding.InstanceIdentifier;
import org.opendaylight.yangtools.yang.binding.RpcService;
import org.opendaylight.yangtools.yang.common.RpcResult;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FibManager
extends AbstractDataChangeListener<VrfEntry>
implements AutoCloseable {
    private static final Logger LOG = LoggerFactory.getLogger(FibManager.class);
    private static final String FLOWID_PREFIX = "L3.";
    private ListenerRegistration<DataChangeListener> listenerRegistration;
    private final DataBroker broker;
    private final L3nexthopService l3nexthopService;
    private IMdsalApiManager mdsalManager;
    private IVpnManager vpnmanager;
    private static final short L3_FIB_TABLE = 21;
    private static final short L3_LFIB_TABLE = 20;
    private static final BigInteger COOKIE_VM_LFIB_TABLE = new BigInteger("8000002", 16);
    private static final BigInteger COOKIE_VM_FIB_TABLE = new BigInteger("8000003", 16);
    private static final int DEFAULT_FIB_FLOW_PRIORITY = 10;
    private static final FutureCallback<Void> DEFAULT_CALLBACK = new FutureCallback<Void>(){

        public void onSuccess(Void result) {
            LOG.debug("Success in Datastore write operation");
        }

        public void onFailure(Throwable error) {
            LOG.error("Error in Datastore write operation", error);
        }
    };

    public FibManager(DataBroker db, RpcService nextHopService) {
        super(VrfEntry.class);
        this.broker = db;
        this.l3nexthopService = (L3nexthopService)nextHopService;
        this.registerListener(db);
    }

    @Override
    public void close() throws Exception {
        if (this.listenerRegistration != null) {
            try {
                this.listenerRegistration.close();
            }
            catch (Exception e) {
                LOG.error("Error when cleaning up DataChangeListener.", (Throwable)e);
            }
            this.listenerRegistration = null;
        }
        LOG.info("Fib Manager Closed");
    }

    public void setMdsalManager(IMdsalApiManager mdsalManager) {
        this.mdsalManager = mdsalManager;
    }

    public void setVpnmanager(IVpnManager vpnmanager) {
        this.vpnmanager = vpnmanager;
    }

    private void registerListener(DataBroker db) {
        try {
            this.listenerRegistration = db.registerDataChangeListener(LogicalDatastoreType.OPERATIONAL, this.getWildCardPath(), (DataChangeListener)this, AsyncDataBroker.DataChangeScope.SUBTREE);
        }
        catch (Exception e) {
            LOG.error("FibManager DataChange listener registration fail!", (Throwable)e);
            throw new IllegalStateException("FibManager registration Listener failed.", e);
        }
    }

    private <T extends DataObject> Optional<T> read(LogicalDatastoreType datastoreType, InstanceIdentifier<T> path) {
        ReadOnlyTransaction tx = this.broker.newReadOnlyTransaction();
        Optional result = Optional.absent();
        try {
            result = (Optional)tx.read(datastoreType, path).get();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        return result;
    }

    private InstanceIdentifier<VrfEntry> getWildCardPath() {
        return InstanceIdentifier.create(FibEntries.class).child(VrfTables.class).child(VrfEntry.class);
    }

    private <T extends DataObject> void asyncWrite(LogicalDatastoreType datastoreType, InstanceIdentifier<T> path, T data, FutureCallback<Void> callback) {
        WriteTransaction tx = this.broker.newWriteOnlyTransaction();
        tx.put(datastoreType, path, data, true);
        Futures.addCallback((ListenableFuture)tx.submit(), callback);
    }

    protected void add(InstanceIdentifier<VrfEntry> identifier, VrfEntry vrfEntry) {
        LOG.trace("key: " + identifier + ", value=" + vrfEntry);
        this.createFibEntries(identifier, vrfEntry);
    }

    protected void remove(InstanceIdentifier<VrfEntry> identifier, VrfEntry vrfEntry) {
        LOG.trace("key: " + identifier + ", value=" + vrfEntry);
        this.deleteFibEntries(identifier, vrfEntry);
    }

    protected void update(InstanceIdentifier<VrfEntry> identifier, VrfEntry original, VrfEntry update) {
        LOG.trace("key: " + identifier + ", original=" + original + ", update=" + update);
    }

    private void createFibEntries(InstanceIdentifier<VrfEntry> identifier, VrfEntry vrfEntry) {
        VrfTablesKey vrfTableKey = (VrfTablesKey)identifier.firstKeyOf(VrfTables.class, VrfTablesKey.class);
        Preconditions.checkNotNull((Object)vrfTableKey, (Object)"VrfTablesKey cannot be null or empty!");
        Preconditions.checkNotNull((Object)vrfEntry, (Object)"VrfEntry cannot be null or empty!");
        Long vpnId = this.getVpnId(vrfTableKey.getRouteDistinguisher());
        Preconditions.checkNotNull((Object)vpnId, (Object)"Vpn Instance not available!");
        Collection dpns = this.vpnmanager.getDpnsForVpn(vpnId.longValue());
        for (BigInteger dpId : dpns) {
            this.addRouteInternal(dpId, vpnId, vrfTableKey, vrfEntry);
        }
    }

    private void addRouteInternal(BigInteger dpId, long vpnId, VrfTablesKey vrfTableKey, VrfEntry vrfEntry) {
        String rd = vrfTableKey.getRouteDistinguisher();
        LOG.debug("adding route " + vrfEntry.getDestPrefix() + " " + rd);
        GetEgressPointerOutput adjacency = this.resolveAdjacency(dpId, vpnId, vrfEntry);
        long groupId = -1L;
        boolean isLocalRoute = false;
        if (adjacency != null) {
            groupId = adjacency.getEgressPointer();
            isLocalRoute = adjacency.isLocalDestination();
        }
        if (groupId == -1L) {
            LOG.error("Could not get nexthop group id for nexthop: {} in vpn {}", (Object)vrfEntry.getNextHopAddress(), (Object)rd);
            LOG.warn("Failed to add Route: {} in vpn: {}", (Object)vrfEntry.getDestPrefix(), (Object)rd);
            return;
        }
        this.makeConnectedRoute(dpId, vpnId, vrfEntry, rd, groupId, 0);
        if (isLocalRoute) {
            this.makeLFibTableEntry(dpId, vrfEntry.getLabel(), groupId, vrfEntry.getNextHopAddress(), 0);
        }
        LOG.debug("Successfully added fib entry for " + vrfEntry.getDestPrefix() + " vpnId " + vpnId);
    }

    private void deleteFibEntries(InstanceIdentifier<VrfEntry> identifier, VrfEntry vrfEntry) {
        VrfTablesKey vrfTableKey = (VrfTablesKey)identifier.firstKeyOf(VrfTables.class, VrfTablesKey.class);
        Preconditions.checkNotNull((Object)vrfTableKey, (Object)"VrfTablesKey cannot be null or empty!");
        Preconditions.checkNotNull((Object)vrfEntry, (Object)"VrfEntry cannot be null or empty!");
        Long vpnId = this.getVpnId(vrfTableKey.getRouteDistinguisher());
        Preconditions.checkNotNull((Object)vpnId, (Object)"Vpn Instance not available!");
        Collection dpns = this.vpnmanager.getDpnsForVpn(vpnId.longValue());
        for (BigInteger dpId : dpns) {
            this.deleteRoute(dpId, vpnId, vrfTableKey, vrfEntry);
        }
    }

    public void deleteRoute(BigInteger dpId, long vpnId, VrfTablesKey vrfTableKey, VrfEntry vrfEntry) {
        LOG.debug("deleting route " + vrfEntry.getDestPrefix() + " " + vpnId);
        String rd = vrfTableKey.getRouteDistinguisher();
        GetEgressPointerOutput adjacency = this.resolveAdjacency(dpId, vpnId, vrfEntry);
        long groupId = -1L;
        boolean isLocalRoute = false;
        if (adjacency != null) {
            groupId = adjacency.getEgressPointer();
            isLocalRoute = adjacency.isLocalDestination();
        }
        if (groupId == -1L) {
            LOG.error("Could not get nexthop group id for nexthop: {} in vpn {}", (Object)vrfEntry.getNextHopAddress(), (Object)rd);
            LOG.warn("Failed to add Route: {} in vpn: {}", (Object)vrfEntry.getDestPrefix(), (Object)rd);
            return;
        }
        this.makeConnectedRoute(dpId, vpnId, vrfEntry, rd, groupId, 1);
        if (isLocalRoute) {
            this.makeLFibTableEntry(dpId, vrfEntry.getLabel(), groupId, vrfEntry.getNextHopAddress(), 1);
            this.deleteLocalAdjacency(dpId, vpnId, vrfEntry);
        }
        LOG.debug("Successfully delete fib entry for " + vrfEntry.getDestPrefix() + " vpnId " + vpnId);
    }

    private long getIpAddress(byte[] rawIpAddress) {
        return (long)(((rawIpAddress[0] & 0xFF) << 24) + ((rawIpAddress[1] & 0xFF) << 16) + ((rawIpAddress[2] & 0xFF) << 8) + (rawIpAddress[3] & 0xFF)) & 0xFFFFFFFFL;
    }

    private void makeConnectedRoute(BigInteger dpId, long vpnId, VrfEntry vrfEntry, String rd, long groupId, int addOrRemove) {
        LOG.trace("makeConnectedRoute: vrfEntry {}", (Object)vrfEntry);
        String[] values = vrfEntry.getDestPrefix().split("/");
        String ipAddress = values[0];
        int prefixLength = values.length == 1 ? 32 : Integer.parseInt(values[1]);
        LOG.debug("Adding route to DPN. ip {} masklen {}", (Object)ipAddress, (Object)prefixLength);
        InetAddress destPrefix = null;
        try {
            destPrefix = InetAddress.getByName(ipAddress);
        }
        catch (UnknownHostException e) {
            LOG.error("UnknowHostException in addRoute. Failed  to add Route for ipPrefix {}", (Object)vrfEntry.getDestPrefix());
            return;
        }
        ArrayList<MatchInfo> matches = new ArrayList<MatchInfo>();
        matches.add(new MatchInfo(MatchFieldType.metadata, new BigInteger[]{BigInteger.valueOf(vpnId), MetaDataUtil.METADATA_MASK_VRFID}));
        matches.add(new MatchInfo(MatchFieldType.eth_type, new long[]{2048L}));
        if (prefixLength != 0) {
            matches.add(new MatchInfo(MatchFieldType.ipv4_dst, new long[]{this.getIpAddress(destPrefix.getAddress()), prefixLength}));
        }
        ArrayList<InstructionInfo> instructions = new ArrayList<InstructionInfo>();
        ArrayList<ActionInfo> actionsInfos = new ArrayList<ActionInfo>();
        if (addOrRemove == 0) {
            actionsInfos.add(new ActionInfo(ActionType.push_mpls, new String[]{null}));
            actionsInfos.add(new ActionInfo(ActionType.set_field_mpls_label, new String[]{Long.toString(vrfEntry.getLabel())}));
            actionsInfos.add(new ActionInfo(ActionType.group, new String[]{String.valueOf(groupId)}));
            instructions.add(new InstructionInfo(InstructionType.write_actions, actionsInfos));
        }
        String flowRef = this.getFlowRef(dpId, (short)21, rd, destPrefix);
        int priority = 10 + prefixLength;
        FlowEntity flowEntity = MDSALUtil.buildFlowEntity((BigInteger)dpId, (short)21, (String)flowRef, (int)priority, (String)flowRef, (int)0, (int)0, (BigInteger)COOKIE_VM_FIB_TABLE, matches, instructions);
        if (addOrRemove == 0) {
            this.mdsalManager.installFlow(flowEntity);
        } else {
            this.mdsalManager.removeFlow(flowEntity);
        }
    }

    private void makeLFibTableEntry(BigInteger dpId, long label, long groupId, String nextHop, int addOrRemove) {
        ArrayList<MatchInfo> matches = new ArrayList<MatchInfo>();
        matches.add(new MatchInfo(MatchFieldType.eth_type, new long[]{34887L}));
        matches.add(new MatchInfo(MatchFieldType.mpls_label, new String[]{Long.toString(label)}));
        ArrayList<InstructionInfo> instructions = new ArrayList<InstructionInfo>();
        ArrayList<ActionInfo> actionsInfos = new ArrayList<ActionInfo>();
        actionsInfos.add(new ActionInfo(ActionType.group, new String[]{String.valueOf(groupId)}));
        instructions.add(new InstructionInfo(InstructionType.write_actions, actionsInfos));
        String flowRef = this.getFlowRef(dpId, (short)20, label, nextHop);
        FlowEntity flowEntity = MDSALUtil.buildFlowEntity((BigInteger)dpId, (short)20, (String)flowRef, (int)10, (String)flowRef, (int)0, (int)0, (BigInteger)COOKIE_VM_LFIB_TABLE, matches, instructions);
        if (addOrRemove == 0) {
            this.mdsalManager.installFlow(flowEntity);
        } else {
            this.mdsalManager.removeFlow(flowEntity);
        }
        LOG.debug("LFIB Entry for dpID {} : label : {} group {} modified successfully {}", new Object[]{dpId, label, groupId});
    }

    private void deleteLocalAdjacency(BigInteger dpId, long vpnId, VrfEntry vrfEntry) {
        LOG.trace("deleteLocalAdjacency called with dpid {}, vpnId{}, VrfEntry {}", new Object[]{dpId, vpnId, vrfEntry});
        try {
            Future result = this.l3nexthopService.removeLocalNextHop(new RemoveLocalNextHopInputBuilder().setDpnId(dpId).setIpPrefix(vrfEntry.getDestPrefix()).setNexthopIp(vrfEntry.getNextHopAddress()).setVpnId(Long.valueOf(vpnId)).build());
            RpcResult rpcResult = (RpcResult)result.get();
            if (rpcResult.isSuccessful()) {
                LOG.debug("Local Next hop for {} on dpn {} successfully deleted", (Object)vrfEntry.getDestPrefix(), (Object)dpId);
            } else {
                LOG.error("Local Next hop for {} on dpn {} not deleted", (Object)vrfEntry.getDestPrefix(), (Object)dpId);
            }
        }
        catch (InterruptedException | NullPointerException | ExecutionException e) {
            LOG.trace("", (Throwable)e);
        }
    }

    public void populateFibOnNewDpn(BigInteger dpnId, long vpnId, String rd) {
        LOG.trace("New dpn {} for vpn {} : populateFibOnNewDpn", (Object)dpnId, (Object)rd);
        InstanceIdentifier<VrfTables> id = FibManager.buildVrfId(rd);
        Optional<VrfTables> vrfTable = this.read(LogicalDatastoreType.OPERATIONAL, id);
        if (vrfTable.isPresent()) {
            for (VrfEntry vrfEntry : ((VrfTables)vrfTable.get()).getVrfEntry()) {
                this.addRouteInternal(dpnId, vpnId, ((VrfTables)vrfTable.get()).getKey(), vrfEntry);
            }
        }
    }

    public void cleanUpDpnForVpn(BigInteger dpnId, long vpnId, String rd) {
        LOG.trace("Remove dpn {} for vpn {} : cleanUpDpnForVpn", (Object)dpnId, (Object)rd);
        InstanceIdentifier<VrfTables> id = FibManager.buildVrfId(rd);
        Optional<VrfTables> vrfTable = this.read(LogicalDatastoreType.OPERATIONAL, id);
        if (vrfTable.isPresent()) {
            for (VrfEntry vrfEntry : ((VrfTables)vrfTable.get()).getVrfEntry()) {
                this.deleteRoute(dpnId, vpnId, ((VrfTables)vrfTable.get()).getKey(), vrfEntry);
            }
        }
    }

    public static InstanceIdentifier<VrfTables> buildVrfId(String rd) {
        InstanceIdentifier.InstanceIdentifierBuilder idBuilder = InstanceIdentifier.builder(FibEntries.class).child(VrfTables.class, (Identifier)new VrfTablesKey(rd));
        InstanceIdentifier id = idBuilder.build();
        return id;
    }

    private String getFlowRef(BigInteger dpnId, short tableId, long label, String nextHop) {
        return new StringBuilder(64).append(FLOWID_PREFIX).append(dpnId).append(".").append(tableId).append(".").append(label).append(".").append(nextHop).toString();
    }

    private String getFlowRef(BigInteger dpnId, short tableId, String rd, InetAddress destPrefix) {
        return new StringBuilder(64).append(FLOWID_PREFIX).append(dpnId).append(".").append(tableId).append(".").append(rd).append(".").append(destPrefix.getHostAddress()).toString();
    }

    protected GetEgressPointerOutput resolveAdjacency(BigInteger dpId, long vpnId, VrfEntry vrfEntry) {
        GetEgressPointerOutput adjacency = null;
        LOG.trace("resolveAdjacency called with dpid {}, vpnId{}, VrfEntry {}", new Object[]{dpId, vpnId, vrfEntry});
        try {
            Future result = this.l3nexthopService.getEgressPointer(new GetEgressPointerInputBuilder().setDpnId(dpId).setIpPrefix(vrfEntry.getDestPrefix()).setNexthopIp(vrfEntry.getNextHopAddress()).setVpnId(Long.valueOf(vpnId)).build());
            RpcResult rpcResult = (RpcResult)result.get();
            if (rpcResult.isSuccessful()) {
                adjacency = (GetEgressPointerOutput)rpcResult.getResult();
            } else {
                LOG.error("Next hop information not available");
            }
        }
        catch (InterruptedException | NullPointerException | ExecutionException e) {
            LOG.trace("", (Throwable)e);
        }
        return adjacency;
    }

    protected Long getVpnId(String rd) {
        Long vpnId = null;
        InstanceIdentifier id = InstanceIdentifier.create(VpnInstances.class);
        Optional vpnInstances = this.read(LogicalDatastoreType.OPERATIONAL, id);
        if (vpnInstances.isPresent()) {
            List vpns = ((VpnInstances)vpnInstances.get()).getVpnInstance();
            for (VpnInstance vpn : vpns) {
                VpnInstance1 vpnInstanceId;
                if (!vpn.getIpv4Family().getRouteDistinguisher().equals(rd) || (vpnInstanceId = (VpnInstance1)vpn.getAugmentation(VpnInstance1.class)) == null) continue;
                vpnId = vpnInstanceId.getVpnId();
                break;
            }
        }
        return vpnId;
    }

    public void processNodeAdd(BigInteger dpnId) {
        LOG.debug("Received notification to install TableMiss entries for dpn {} ", (Object)dpnId);
        this.makeTableMissFlow(dpnId, 0);
    }

    private void makeTableMissFlow(BigInteger dpnId, int addOrRemove) {
        BigInteger COOKIE_TABLE_MISS = new BigInteger("1030000", 16);
        ArrayList<InstructionInfo> instructions = new ArrayList<InstructionInfo>();
        ArrayList<ActionInfo> actionsInfos = new ArrayList<ActionInfo>();
        actionsInfos.add(new ActionInfo(ActionType.punt_to_controller, new String[0]));
        instructions.add(new InstructionInfo(InstructionType.write_actions, actionsInfos));
        ArrayList matches = new ArrayList();
        FlowEntity flowEntityLfib = MDSALUtil.buildFlowEntity((BigInteger)dpnId, (short)20, (String)this.getFlowRef(dpnId, (short)20, 0), (int)0, (String)"Table Miss", (int)0, (int)0, (BigInteger)COOKIE_TABLE_MISS, matches, instructions);
        FlowEntity flowEntityFib = MDSALUtil.buildFlowEntity((BigInteger)dpnId, (short)21, (String)this.getFlowRef(dpnId, (short)21, 0), (int)0, (String)"FIB Table Miss Flow", (int)0, (int)0, (BigInteger)COOKIE_VM_FIB_TABLE, matches, instructions);
        if (addOrRemove == 0) {
            LOG.debug("Invoking MDSAL to install Table Miss Entries");
            this.mdsalManager.installFlow(flowEntityLfib);
            this.mdsalManager.installFlow(flowEntityFib);
        } else {
            this.mdsalManager.removeFlow(flowEntityLfib);
            this.mdsalManager.removeFlow(flowEntityFib);
        }
    }

    private String getFlowRef(BigInteger dpnId, short tableId, int tableMiss) {
        return new StringBuffer().append(FLOWID_PREFIX).append(dpnId).append(".").append(tableId).append(".").append(tableMiss).append(FLOWID_PREFIX).toString();
    }
}

