/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.transportpce.nbinotifications.utils;

import java.io.IOException;
import java.io.InputStream;
import java.util.Map;
import java.util.Properties;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.opendaylight.yang.gen.v1.nbi.notifications.rev211013.NotificationTapiService;
import org.opendaylight.yang.gen.v1.nbi.notifications.rev211013.NotificationTapiServiceBuilder;
import org.opendaylight.yang.gen.v1.nbi.notifications.rev211013.PublishTapiNotificationService;
import org.opendaylight.yang.gen.v1.nbi.notifications.rev211013.notification.tapi.service.AdditionalInfo;
import org.opendaylight.yang.gen.v1.nbi.notifications.rev211013.notification.tapi.service.AdditionalInfoBuilder;
import org.opendaylight.yang.gen.v1.nbi.notifications.rev211013.notification.tapi.service.AdditionalInfoKey;
import org.opendaylight.yang.gen.v1.nbi.notifications.rev211013.notification.tapi.service.AlarmInfoBuilder;
import org.opendaylight.yang.gen.v1.nbi.notifications.rev211013.notification.tapi.service.ChangedAttributes;
import org.opendaylight.yang.gen.v1.nbi.notifications.rev211013.notification.tapi.service.ChangedAttributesBuilder;
import org.opendaylight.yang.gen.v1.nbi.notifications.rev211013.notification.tapi.service.ChangedAttributesKey;
import org.opendaylight.yang.gen.v1.nbi.notifications.rev211013.notification.tapi.service.TargetObjectName;
import org.opendaylight.yang.gen.v1.nbi.notifications.rev211013.notification.tapi.service.TargetObjectNameBuilder;
import org.opendaylight.yang.gen.v1.nbi.notifications.rev211013.notification.tapi.service.TargetObjectNameKey;
import org.opendaylight.yang.gen.v1.nbi.notifications.rev211013.notification.tapi.service.TcaInfoBuilder;
import org.opendaylight.yang.gen.v1.urn.onf.otcc.yang.tapi.common.rev181210.NameAndValue;
import org.opendaylight.yang.gen.v1.urn.onf.otcc.yang.tapi.common.rev181210.global._class.Name;
import org.opendaylight.yang.gen.v1.urn.onf.otcc.yang.tapi.notification.rev181210.AlarmInfo;
import org.opendaylight.yang.gen.v1.urn.onf.otcc.yang.tapi.notification.rev181210.NameAndValueChange;
import org.opendaylight.yang.gen.v1.urn.onf.otcc.yang.tapi.notification.rev181210.TcaInfo;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class NbiNotificationsUtils {
    private static final Logger LOG = LoggerFactory.getLogger(NbiNotificationsUtils.class);

    private NbiNotificationsUtils() {
    }

    public static Properties loadProperties(String propertyFileName) {
        Properties props = new Properties();
        InputStream inputStream = NbiNotificationsUtils.class.getClassLoader().getResourceAsStream(propertyFileName);
        try {
            if (inputStream != null) {
                props.load(inputStream);
            } else {
                LOG.warn("Kafka property file '{}' is empty", (Object)propertyFileName);
            }
        }
        catch (IOException e) {
            LOG.error("Kafka property file '{}' was not found in the classpath", (Object)propertyFileName, (Object)e);
        }
        return props;
    }

    public static NotificationTapiService transformTapiNotification(PublishTapiNotificationService notification) {
        Map<AdditionalInfoKey, AdditionalInfo> addInfoMap = notification.nonnullAdditionalInfo().values().stream().collect(Collectors.toMap(e -> new AdditionalInfoKey(e.getValueName()), e -> new AdditionalInfoBuilder((NameAndValue)e).build()));
        Map<ChangedAttributesKey, ChangedAttributes> changedAttMap = notification.nonnullChangedAttributes().values().stream().collect(Collectors.toMap(e -> new ChangedAttributesKey(e.getValueName()), e -> new ChangedAttributesBuilder((NameAndValueChange)e).build()));
        Map nameMap = notification.nonnullName().values().stream().collect(Collectors.toMap(Name::key, Function.identity()));
        Map<TargetObjectNameKey, TargetObjectName> targetObjNameMap = notification.nonnullTargetObjectName().values().stream().collect(Collectors.toMap(e -> new TargetObjectNameKey(e.getValueName()), e -> new TargetObjectNameBuilder((NameAndValue)e).build()));
        LOG.info("Notification uuid = {}", (Object)notification.getUuid());
        return new NotificationTapiServiceBuilder().setAlarmInfo(notification.getAlarmInfo() == null ? null : new AlarmInfoBuilder((AlarmInfo)notification.getAlarmInfo()).build()).setAdditionalText(notification.getAdditionalText()).setAdditionalInfo(addInfoMap).setNotificationType(notification.getNotificationType()).setChangedAttributes(changedAttMap).setEventTimeStamp(notification.getEventTimeStamp()).setLayerProtocolName(notification.getLayerProtocolName()).setName(nameMap).setSequenceNumber(notification.getSequenceNumber()).setSourceIndicator(notification.getSourceIndicator()).setTargetObjectIdentifier(notification.getTargetObjectIdentifier()).setTargetObjectName(targetObjNameMap).setTargetObjectType(notification.getTargetObjectType()).setTcaInfo(notification.getTcaInfo() == null ? null : new TcaInfoBuilder((TcaInfo)notification.getTcaInfo()).build()).setUuid(notification.getUuid()).build();
    }
}

