/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.transportpce.nbinotifications.impl;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.opendaylight.mdsal.binding.api.NotificationService;
import org.opendaylight.mdsal.binding.api.RpcProviderService;
import org.opendaylight.mdsal.binding.dom.codec.spi.BindingDOMCodecServices;
import org.opendaylight.transportpce.common.converter.JsonStringConverter;
import org.opendaylight.transportpce.common.network.NetworkTransactionService;
import org.opendaylight.transportpce.nbinotifications.impl.NbiNotificationsImpl;
import org.opendaylight.transportpce.nbinotifications.listener.NbiNotificationsListenerImpl;
import org.opendaylight.transportpce.nbinotifications.producer.Publisher;
import org.opendaylight.transportpce.nbinotifications.utils.TopicManager;
import org.opendaylight.yang.gen.v1.nbi.notifications.rev211013.NbiNotificationsListener;
import org.opendaylight.yang.gen.v1.nbi.notifications.rev211013.NbiNotificationsService;
import org.opendaylight.yang.gen.v1.nbi.notifications.rev211013.NotificationAlarmService;
import org.opendaylight.yang.gen.v1.nbi.notifications.rev211013.NotificationProcessService;
import org.opendaylight.yang.gen.v1.nbi.notifications.rev211013.NotificationTapiService;
import org.opendaylight.yang.gen.v1.urn.onf.otcc.yang.tapi.notification.rev181210.TapiNotificationService;
import org.opendaylight.yangtools.concepts.ListenerRegistration;
import org.opendaylight.yangtools.concepts.ObjectRegistration;
import org.opendaylight.yangtools.yang.binding.NotificationListener;
import org.opendaylight.yangtools.yang.binding.RpcService;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Deactivate;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.metatype.annotations.AttributeDefinition;
import org.osgi.service.metatype.annotations.ObjectClassDefinition;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(configurationPid={"org.opendaylight.transportpce.nbinotifications"})
public class NbiNotificationsProvider {
    private static final Logger LOG = LoggerFactory.getLogger(NbiNotificationsProvider.class);
    private static Map<String, Publisher<NotificationProcessService>> publishersServiceMap = new HashMap<String, Publisher<NotificationProcessService>>();
    private static Map<String, Publisher<NotificationAlarmService>> publishersAlarmMap = new HashMap<String, Publisher<NotificationAlarmService>>();
    private ListenerRegistration<NbiNotificationsListener> listenerRegistration;
    private List<ObjectRegistration<NbiNotificationsImpl>> rpcRegistrations = new ArrayList<ObjectRegistration<NbiNotificationsImpl>>();

    @Activate
    public NbiNotificationsProvider(@Reference RpcProviderService rpcProviderService, @Reference NotificationService notificationService, @Reference BindingDOMCodecServices bindingDOMCodecServices, @Reference NetworkTransactionService networkTransactionService, Configuration configuration) {
        this(configuration.suscriberServer(), configuration.publisherServer(), rpcProviderService, notificationService, bindingDOMCodecServices, networkTransactionService);
    }

    public NbiNotificationsProvider(String subscriberServer, String publisherServer, RpcProviderService rpcProviderService, NotificationService notificationService, BindingDOMCodecServices bindingDOMCodecServices, NetworkTransactionService networkTransactionService) {
        List<String> publishersServiceList = List.of("PceListener", "ServiceHandlerOperations", "ServiceHandler", "RendererListener");
        TopicManager topicManager = TopicManager.getInstance();
        topicManager.setPublisherServer(publisherServer);
        JsonStringConverter converterService = new JsonStringConverter(bindingDOMCodecServices);
        topicManager.setProcessConverter((JsonStringConverter<NotificationProcessService>)converterService);
        for (String publisherService : publishersServiceList) {
            LOG.info("Creating publisher for the following class {}", (Object)publisherService);
            topicManager.addProcessTopic(publisherService);
        }
        JsonStringConverter converterAlarmService = new JsonStringConverter(bindingDOMCodecServices);
        topicManager.setAlarmConverter((JsonStringConverter<NotificationAlarmService>)converterAlarmService);
        List<String> publishersAlarmList = List.of("ServiceListener");
        for (String publisherAlarm : publishersAlarmList) {
            LOG.info("Creating publisher for the following class {}", (Object)publisherAlarm);
            topicManager.addAlarmTopic(publisherAlarm);
        }
        JsonStringConverter converterTapiService = new JsonStringConverter(bindingDOMCodecServices);
        LOG.info("baozhi tapi converter: {}", (Object)converterTapiService);
        topicManager.setTapiConverter((JsonStringConverter<NotificationTapiService>)converterTapiService);
        NbiNotificationsImpl nbiImpl = new NbiNotificationsImpl((JsonStringConverter<NotificationProcessService>)converterService, (JsonStringConverter<NotificationAlarmService>)converterAlarmService, (JsonStringConverter<NotificationTapiService>)converterTapiService, subscriberServer, networkTransactionService, topicManager);
        this.rpcRegistrations.add((ObjectRegistration<NbiNotificationsImpl>)rpcProviderService.registerRpcImplementation(NbiNotificationsService.class, (RpcService)nbiImpl));
        this.rpcRegistrations.add((ObjectRegistration<NbiNotificationsImpl>)rpcProviderService.registerRpcImplementation(TapiNotificationService.class, (RpcService)nbiImpl));
        NbiNotificationsListenerImpl nbiNotificationsListener = new NbiNotificationsListenerImpl(topicManager.getProcessTopicMap(), topicManager.getAlarmTopicMap(), topicManager.getTapiTopicMap());
        this.listenerRegistration = notificationService.registerNotificationListener((NotificationListener)nbiNotificationsListener);
        topicManager.setNbiNotificationsListener(nbiNotificationsListener);
        LOG.info("NbiNotificationsProvider Session Initiated");
    }

    @Deactivate
    public void close() {
        for (Publisher<NotificationProcessService> publisher : publishersServiceMap.values()) {
            publisher.close();
        }
        for (Publisher<NotificationProcessService> publisher : publishersAlarmMap.values()) {
            publisher.close();
        }
        this.rpcRegistrations.forEach(reg -> reg.close());
        this.listenerRegistration.close();
        LOG.info("NbiNotificationsProvider Closed");
    }

    @ObjectClassDefinition
    public static @interface Configuration {
        @AttributeDefinition
        public String suscriberServer() default "";

        @AttributeDefinition
        public String publisherServer() default "";
    }
}

