/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.transportpce.nbinotifications.serialization;

import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.Map;
import org.apache.kafka.common.serialization.Serializer;
import org.opendaylight.transportpce.common.converter.JsonStringConverter;
import org.opendaylight.yang.gen.v1.nbi.notifications.rev211013.NotificationTapiService;
import org.opendaylight.yangtools.yang.binding.DataObject;
import org.opendaylight.yangtools.yang.binding.InstanceIdentifier;
import org.opendaylight.yangtools.yang.data.codec.gson.JSONCodecFactorySupplier;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TapiNotificationSerializer
implements Serializer<NotificationTapiService> {
    private static final Logger LOG = LoggerFactory.getLogger(TapiNotificationSerializer.class);
    private JsonStringConverter<NotificationTapiService> converter;

    public void configure(Map<String, ?> configs, boolean isKey) {
        LOG.info("Deserializer configuration {}", configs);
        if (configs.containsKey("converter") && configs.get("converter") instanceof JsonStringConverter) {
            this.converter = (JsonStringConverter)configs.get("converter");
        }
    }

    public byte[] serialize(String topic, NotificationTapiService data) {
        if (this.converter == null) {
            throw new IllegalArgumentException("Converter should be configured through configure method of serializer");
        }
        if (data == null) {
            LOG.error("Notification data is empty");
            return new byte[0];
        }
        try {
            InstanceIdentifier iid = InstanceIdentifier.builder(NotificationTapiService.class).build();
            String serialized = this.converter.createJsonStringFromDataObject(iid, (DataObject)data, JSONCodecFactorySupplier.RFC7951);
            LOG.info("Serialized event {}", (Object)serialized);
            return serialized.getBytes(StandardCharsets.UTF_8);
        }
        catch (IOException e) {
            LOG.error("Event couldnt be serialized", (Throwable)e);
            return new byte[0];
        }
    }
}

