/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.transportpce.nbinotifications.listener;

import java.util.Map;
import org.opendaylight.transportpce.nbinotifications.producer.Publisher;
import org.opendaylight.transportpce.nbinotifications.utils.NbiNotificationsUtils;
import org.opendaylight.yang.gen.v1.nbi.notifications.rev211013.NbiNotificationsListener;
import org.opendaylight.yang.gen.v1.nbi.notifications.rev211013.NotificationAlarmService;
import org.opendaylight.yang.gen.v1.nbi.notifications.rev211013.NotificationAlarmServiceBuilder;
import org.opendaylight.yang.gen.v1.nbi.notifications.rev211013.NotificationProcessService;
import org.opendaylight.yang.gen.v1.nbi.notifications.rev211013.NotificationProcessServiceBuilder;
import org.opendaylight.yang.gen.v1.nbi.notifications.rev211013.NotificationTapiService;
import org.opendaylight.yang.gen.v1.nbi.notifications.rev211013.NotificationTapiServiceBuilder;
import org.opendaylight.yang.gen.v1.nbi.notifications.rev211013.PublishNotificationAlarmService;
import org.opendaylight.yang.gen.v1.nbi.notifications.rev211013.PublishNotificationProcessService;
import org.opendaylight.yang.gen.v1.nbi.notifications.rev211013.PublishTapiNotificationService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NbiNotificationsListenerImpl
implements NbiNotificationsListener {
    private static final Logger LOG = LoggerFactory.getLogger(NbiNotificationsListenerImpl.class);
    private Map<String, Publisher<NotificationProcessService>> publishersServiceMap;
    private Map<String, Publisher<NotificationAlarmService>> publishersAlarmMap;
    private Map<String, Publisher<NotificationTapiService>> tapiPublisherMap;

    public NbiNotificationsListenerImpl(Map<String, Publisher<NotificationProcessService>> publishersServiceMap, Map<String, Publisher<NotificationAlarmService>> publishersAlarmMap, Map<String, Publisher<NotificationTapiService>> tapiPublisherMap) {
        this.publishersServiceMap = publishersServiceMap;
        this.publishersAlarmMap = publishersAlarmMap;
        this.tapiPublisherMap = tapiPublisherMap;
    }

    public void onPublishNotificationProcessService(PublishNotificationProcessService notification) {
        LOG.info("Receiving request for publishing notification service");
        String publisherName = notification.getPublisherName();
        if (!this.publishersServiceMap.containsKey(publisherName)) {
            LOG.error("Unknown publisher {}", (Object)publisherName);
            return;
        }
        Publisher<NotificationProcessService> publisher = this.publishersServiceMap.get(publisherName);
        publisher.sendEvent(new NotificationProcessServiceBuilder().setCommonId(notification.getCommonId()).setConnectionType(notification.getConnectionType()).setMessage(notification.getMessage()).setOperationalState(notification.getOperationalState()).setResponseFailed(notification.getResponseFailed()).setServiceAEnd(notification.getServiceAEnd()).setServiceName(notification.getServiceName()).setServiceZEnd(notification.getServiceZEnd()).build(), notification.getConnectionType().getName());
    }

    public void onPublishNotificationAlarmService(PublishNotificationAlarmService notification) {
        LOG.info("Receiving request for publishing notification alarm service");
        String publisherName = notification.getPublisherName();
        if (!this.publishersAlarmMap.containsKey(publisherName)) {
            LOG.error("Unknown topic {}", (Object)publisherName);
            return;
        }
        Publisher<NotificationAlarmService> publisherAlarm = this.publishersAlarmMap.get(publisherName);
        publisherAlarm.sendEvent(new NotificationAlarmServiceBuilder().setConnectionType(notification.getConnectionType()).setMessage(notification.getMessage()).setOperationalState(notification.getOperationalState()).setServiceName(notification.getServiceName()).build(), "alarm" + notification.getConnectionType().getName());
    }

    public void onPublishTapiNotificationService(PublishTapiNotificationService notification) {
        LOG.info("Receiving request for publishing TAPI notification");
        String topic = notification.getTopic();
        if (!this.tapiPublisherMap.containsKey(topic)) {
            LOG.error("Unknown topic {}", (Object)topic);
            return;
        }
        Publisher<NotificationTapiService> publisher = this.tapiPublisherMap.get(topic);
        publisher.sendEvent(new NotificationTapiServiceBuilder(NbiNotificationsUtils.transformTapiNotification(notification)).build(), topic);
    }

    public void setPublishersServiceMap(Map<String, Publisher<NotificationProcessService>> publishersServiceMap) {
        this.publishersServiceMap = publishersServiceMap;
    }

    public void setPublishersAlarmMap(Map<String, Publisher<NotificationAlarmService>> publishersAlarmMap) {
        this.publishersAlarmMap = publishersAlarmMap;
    }

    public void setTapiPublishersMap(Map<String, Publisher<NotificationTapiService>> tapiPublishersMap) {
        this.tapiPublisherMap = tapiPublishersMap;
    }

    public Publisher<NotificationTapiService> getTapiPublisherFromTopic(String topic) {
        return this.tapiPublisherMap.get(topic);
    }
}

