/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.transportpce.nbinotifications.impl;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.opendaylight.mdsal.binding.api.NotificationService;
import org.opendaylight.mdsal.binding.api.RpcProviderService;
import org.opendaylight.mdsal.binding.dom.codec.spi.BindingDOMCodecServices;
import org.opendaylight.transportpce.common.converter.JsonStringConverter;
import org.opendaylight.transportpce.common.network.NetworkTransactionService;
import org.opendaylight.transportpce.nbinotifications.impl.NbiNotificationsImpl;
import org.opendaylight.transportpce.nbinotifications.listener.NbiNotificationsListenerImpl;
import org.opendaylight.transportpce.nbinotifications.producer.Publisher;
import org.opendaylight.transportpce.nbinotifications.utils.TopicManager;
import org.opendaylight.yang.gen.v1.nbi.notifications.rev211013.NbiNotificationsListener;
import org.opendaylight.yang.gen.v1.nbi.notifications.rev211013.NbiNotificationsService;
import org.opendaylight.yang.gen.v1.nbi.notifications.rev211013.NotificationAlarmService;
import org.opendaylight.yang.gen.v1.nbi.notifications.rev211013.NotificationProcessService;
import org.opendaylight.yang.gen.v1.nbi.notifications.rev211013.NotificationTapiService;
import org.opendaylight.yang.gen.v1.urn.onf.otcc.yang.tapi.notification.rev181210.TapiNotificationService;
import org.opendaylight.yangtools.concepts.ListenerRegistration;
import org.opendaylight.yangtools.concepts.ObjectRegistration;
import org.opendaylight.yangtools.yang.binding.NotificationListener;
import org.opendaylight.yangtools.yang.binding.RpcService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NbiNotificationsProvider {
    private static final Logger LOG = LoggerFactory.getLogger(NbiNotificationsProvider.class);
    private static Map<String, Publisher<NotificationProcessService>> publishersServiceMap = new HashMap<String, Publisher<NotificationProcessService>>();
    private static Map<String, Publisher<NotificationAlarmService>> publishersAlarmMap = new HashMap<String, Publisher<NotificationAlarmService>>();
    private final RpcProviderService rpcService;
    private final NotificationService notificationService;
    private final JsonStringConverter<NotificationProcessService> converterService;
    private final JsonStringConverter<NotificationAlarmService> converterAlarmService;
    private final JsonStringConverter<NotificationTapiService> converterTapiService;
    private final String subscriberServer;
    private ObjectRegistration<NbiNotificationsService> rpcRegistration;
    private ListenerRegistration<NbiNotificationsListener> listenerRegistration;
    private TopicManager topicManager = TopicManager.getInstance();
    private final NetworkTransactionService networkTransactionService;

    public NbiNotificationsProvider(List<String> publishersService, List<String> publishersAlarm, String subscriberServer, String publisherServer, RpcProviderService rpcProviderService, NotificationService notificationService, BindingDOMCodecServices bindingDOMCodecServices, NetworkTransactionService networkTransactionService) {
        this.rpcService = rpcProviderService;
        this.notificationService = notificationService;
        this.topicManager.setPublisherServer(publisherServer);
        this.converterService = new JsonStringConverter(bindingDOMCodecServices);
        this.topicManager.setProcessConverter(this.converterService);
        for (String publisherService : publishersService) {
            LOG.info("Creating publisher for the following class {}", (Object)publisherService);
            this.topicManager.addProcessTopic(publisherService);
        }
        this.converterAlarmService = new JsonStringConverter(bindingDOMCodecServices);
        this.topicManager.setAlarmConverter(this.converterAlarmService);
        for (String publisherAlarm : publishersAlarm) {
            LOG.info("Creating publisher for the following class {}", (Object)publisherAlarm);
            this.topicManager.addAlarmTopic(publisherAlarm);
        }
        this.subscriberServer = subscriberServer;
        this.converterTapiService = new JsonStringConverter(bindingDOMCodecServices);
        LOG.info("baozhi tapi converter: {}", this.converterTapiService);
        this.topicManager.setTapiConverter(this.converterTapiService);
        this.networkTransactionService = networkTransactionService;
    }

    public void init() {
        LOG.info("NbiNotificationsProvider Session Initiated");
        NbiNotificationsImpl nbiImpl = new NbiNotificationsImpl(this.converterService, this.converterAlarmService, this.converterTapiService, this.subscriberServer, this.networkTransactionService, this.topicManager);
        this.rpcRegistration = this.rpcService.registerRpcImplementation(NbiNotificationsService.class, (RpcService)nbiImpl);
        this.rpcService.registerRpcImplementation(TapiNotificationService.class, (RpcService)nbiImpl);
        NbiNotificationsListenerImpl nbiNotificationsListener = new NbiNotificationsListenerImpl(this.topicManager.getProcessTopicMap(), this.topicManager.getAlarmTopicMap(), this.topicManager.getTapiTopicMap());
        this.listenerRegistration = this.notificationService.registerNotificationListener((NotificationListener)nbiNotificationsListener);
        this.topicManager.setNbiNotificationsListener(nbiNotificationsListener);
    }

    public void close() {
        for (Publisher<NotificationProcessService> publisher : publishersServiceMap.values()) {
            publisher.close();
        }
        for (Publisher<NotificationProcessService> publisher : publishersAlarmMap.values()) {
            publisher.close();
        }
        this.rpcRegistration.close();
        this.listenerRegistration.close();
        LOG.info("NbiNotificationsProvider Closed");
    }
}

