/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.transportpce.nbinotifications.utils;

import java.util.HashMap;
import java.util.Map;
import org.opendaylight.transportpce.common.converter.JsonStringConverter;
import org.opendaylight.transportpce.nbinotifications.listener.NbiNotificationsListenerImpl;
import org.opendaylight.transportpce.nbinotifications.producer.Publisher;
import org.opendaylight.transportpce.nbinotifications.serialization.NotificationAlarmServiceSerializer;
import org.opendaylight.transportpce.nbinotifications.serialization.NotificationServiceSerializer;
import org.opendaylight.transportpce.nbinotifications.serialization.TapiNotificationSerializer;
import org.opendaylight.yang.gen.v1.nbi.notifications.rev211013.NotificationAlarmService;
import org.opendaylight.yang.gen.v1.nbi.notifications.rev211013.NotificationProcessService;
import org.opendaylight.yang.gen.v1.nbi.notifications.rev211013.NotificationTapiService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class TopicManager {
    private static final Logger LOG = LoggerFactory.getLogger(TopicManager.class);
    private static TopicManager instance = new TopicManager();
    private Map<String, Publisher<NotificationTapiService>> tapiPublisherMap = new HashMap<String, Publisher<NotificationTapiService>>();
    private String publisherServer;
    private JsonStringConverter<NotificationTapiService> tapiConverter;
    private NbiNotificationsListenerImpl nbiNotificationsListener;
    private Map<String, Publisher<NotificationAlarmService>> alarmPublisherMap = new HashMap<String, Publisher<NotificationAlarmService>>();
    private Map<String, Publisher<NotificationProcessService>> processPublisherMap = new HashMap<String, Publisher<NotificationProcessService>>();
    private JsonStringConverter<NotificationProcessService> processConverter;
    private JsonStringConverter<NotificationAlarmService> alarmConverter;
    private int calledSetConverter = 0;

    private TopicManager() {
    }

    public static TopicManager getInstance() {
        return instance;
    }

    public void setNbiNotificationsListener(NbiNotificationsListenerImpl nbiNotificationsListener) {
        this.nbiNotificationsListener = nbiNotificationsListener;
    }

    public void setProcessConverter(JsonStringConverter<NotificationProcessService> processConverter) {
        this.processConverter = processConverter;
    }

    public void setAlarmConverter(JsonStringConverter<NotificationAlarmService> alarmConverter) {
        this.alarmConverter = alarmConverter;
    }

    public void setTapiConverter(JsonStringConverter<NotificationTapiService> tapiConverter) {
        this.tapiConverter = tapiConverter;
        ++this.calledSetConverter;
    }

    public void setPublisherServer(String publisherServer) {
        this.publisherServer = publisherServer;
    }

    public void addProcessTopic(String topic) {
        LOG.info("Adding process topic: {}", (Object)topic);
        this.processPublisherMap.put(topic, new Publisher<NotificationProcessService>(topic, this.publisherServer, this.processConverter, NotificationServiceSerializer.class));
        if (this.nbiNotificationsListener != null) {
            this.nbiNotificationsListener.setPublishersServiceMap(this.processPublisherMap);
        }
    }

    public void addAlarmTopic(String topic) {
        LOG.info("Adding alarm topic: {}", (Object)topic);
        this.alarmPublisherMap.put(topic, new Publisher<NotificationAlarmService>(topic, this.publisherServer, this.alarmConverter, NotificationAlarmServiceSerializer.class));
        if (this.nbiNotificationsListener != null) {
            this.nbiNotificationsListener.setPublishersAlarmMap(this.alarmPublisherMap);
        }
    }

    public void addTapiTopic(String topic) {
        if (this.tapiPublisherMap.containsKey(topic)) {
            LOG.info("Tapi topic: {} already exists", (Object)topic);
            return;
        }
        LOG.info("Adding new tapi topic: {}", (Object)topic);
        this.tapiPublisherMap.put(topic, new Publisher<NotificationTapiService>(topic, this.publisherServer, this.tapiConverter, TapiNotificationSerializer.class));
        if (this.nbiNotificationsListener != null) {
            this.nbiNotificationsListener.setTapiPublishersMap(this.tapiPublisherMap);
        }
    }

    public void deleteTapiTopic(String topic) {
        if (!this.tapiPublisherMap.containsKey(topic)) {
            LOG.info("Tapi topic: {} doesnt exist", (Object)topic);
            return;
        }
        LOG.info("Deleting tapi topic: {}", (Object)topic);
        this.tapiPublisherMap.remove(topic);
        if (this.nbiNotificationsListener != null) {
            this.nbiNotificationsListener.setTapiPublishersMap(this.tapiPublisherMap);
        }
    }

    public Map<String, Publisher<NotificationTapiService>> getTapiTopicMap() {
        return this.tapiPublisherMap;
    }

    public Map<String, Publisher<NotificationAlarmService>> getAlarmTopicMap() {
        return this.alarmPublisherMap;
    }

    public Map<String, Publisher<NotificationProcessService>> getProcessTopicMap() {
        return this.processPublisherMap;
    }
}

