/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.transportpce.nbinotifications.serialization;

import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.Map;
import org.apache.kafka.common.serialization.Deserializer;
import org.opendaylight.transportpce.common.converter.JsonStringConverter;
import org.opendaylight.yang.gen.v1.nbi.notifications.rev211013.NotificationTapiService;
import org.opendaylight.yang.gen.v1.nbi.notifications.rev211013.notification.tapi.service.TargetObjectName;
import org.opendaylight.yang.gen.v1.urn.onf.otcc.yang.tapi.common.rev181210.NameAndValue;
import org.opendaylight.yang.gen.v1.urn.onf.otcc.yang.tapi.common.rev181210.global._class.Name;
import org.opendaylight.yang.gen.v1.urn.onf.otcc.yang.tapi.common.rev181210.global._class.NameBuilder;
import org.opendaylight.yang.gen.v1.urn.onf.otcc.yang.tapi.common.rev181210.global._class.NameKey;
import org.opendaylight.yang.gen.v1.urn.onf.otcc.yang.tapi.notification.rev181210.AlarmInfo;
import org.opendaylight.yang.gen.v1.urn.onf.otcc.yang.tapi.notification.rev181210.NameAndValueChange;
import org.opendaylight.yang.gen.v1.urn.onf.otcc.yang.tapi.notification.rev181210.TcaInfo;
import org.opendaylight.yang.gen.v1.urn.onf.otcc.yang.tapi.notification.rev181210.get.notification.list.output.Notification;
import org.opendaylight.yang.gen.v1.urn.onf.otcc.yang.tapi.notification.rev181210.get.notification.list.output.NotificationBuilder;
import org.opendaylight.yang.gen.v1.urn.onf.otcc.yang.tapi.notification.rev181210.notification.AdditionalInfo;
import org.opendaylight.yang.gen.v1.urn.onf.otcc.yang.tapi.notification.rev181210.notification.AdditionalInfoBuilder;
import org.opendaylight.yang.gen.v1.urn.onf.otcc.yang.tapi.notification.rev181210.notification.AdditionalInfoKey;
import org.opendaylight.yang.gen.v1.urn.onf.otcc.yang.tapi.notification.rev181210.notification.AlarmInfoBuilder;
import org.opendaylight.yang.gen.v1.urn.onf.otcc.yang.tapi.notification.rev181210.notification.ChangedAttributes;
import org.opendaylight.yang.gen.v1.urn.onf.otcc.yang.tapi.notification.rev181210.notification.ChangedAttributesBuilder;
import org.opendaylight.yang.gen.v1.urn.onf.otcc.yang.tapi.notification.rev181210.notification.ChangedAttributesKey;
import org.opendaylight.yang.gen.v1.urn.onf.otcc.yang.tapi.notification.rev181210.notification.TargetObjectNameBuilder;
import org.opendaylight.yang.gen.v1.urn.onf.otcc.yang.tapi.notification.rev181210.notification.TargetObjectNameKey;
import org.opendaylight.yang.gen.v1.urn.onf.otcc.yang.tapi.notification.rev181210.notification.TcaInfoBuilder;
import org.opendaylight.yangtools.yang.common.QName;
import org.opendaylight.yangtools.yang.data.api.YangInstanceIdentifier;
import org.opendaylight.yangtools.yang.data.codec.gson.JSONCodecFactorySupplier;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TapiNotificationDeserializer
implements Deserializer<Notification> {
    private static final Logger LOG = LoggerFactory.getLogger(TapiNotificationDeserializer.class);
    private JsonStringConverter<NotificationTapiService> converter;

    public void configure(Map<String, ?> configs, boolean isKey) {
        LOG.info("Tapi Deserializer configuration {}", configs);
        if (configs.containsKey("converter") && configs.get("converter") instanceof JsonStringConverter) {
            this.converter = (JsonStringConverter)configs.get("converter");
        }
    }

    public Notification deserialize(String topic, byte[] data) {
        if (this.converter == null) {
            throw new IllegalArgumentException("Converter should be configured through configure method of deserializer");
        }
        String value = new String(data, StandardCharsets.UTF_8);
        NotificationTapiService mappedString = (NotificationTapiService)this.converter.createDataObjectFromJsonString(YangInstanceIdentifier.of((QName)NotificationTapiService.QNAME), value, JSONCodecFactorySupplier.RFC7951);
        if (mappedString == null) {
            return null;
        }
        LOG.info("Reading Tapi event {}", (Object)mappedString);
        return this.transformNotificationTapiService(mappedString);
    }

    private Notification transformNotificationTapiService(NotificationTapiService mappedString) {
        LOG.info("Transforming TAPI notification for getNotificationList rpc");
        HashMap<AdditionalInfoKey, AdditionalInfo> addInfoMap = new HashMap<AdditionalInfoKey, AdditionalInfo>();
        if (mappedString.getAdditionalInfo() != null) {
            for (Object addInfo : mappedString.getAdditionalInfo().values()) {
                AdditionalInfo transAddInfo = new AdditionalInfoBuilder().setValue(addInfo.getValue()).setValueName(addInfo.getValueName()).build();
                addInfoMap.put(transAddInfo.key(), transAddInfo);
            }
        }
        HashMap<ChangedAttributesKey, ChangedAttributes> changedAttMap = new HashMap<ChangedAttributesKey, ChangedAttributes>();
        if (mappedString.getChangedAttributes() != null) {
            for (Object changedAtt : mappedString.getChangedAttributes().values()) {
                ChangedAttributes transChangedAtt = new ChangedAttributesBuilder((NameAndValueChange)changedAtt).build();
                changedAttMap.put(transChangedAtt.key(), transChangedAtt);
            }
        }
        HashMap<NameKey, Name> nameMap = new HashMap<NameKey, Name>();
        if (mappedString.getName() != null) {
            for (Name name : mappedString.getName().values()) {
                Name transName = new NameBuilder(name).build();
                nameMap.put(transName.key(), transName);
            }
        }
        HashMap<TargetObjectNameKey, org.opendaylight.yang.gen.v1.urn.onf.otcc.yang.tapi.notification.rev181210.notification.TargetObjectName> targetObjNameMap = new HashMap<TargetObjectNameKey, org.opendaylight.yang.gen.v1.urn.onf.otcc.yang.tapi.notification.rev181210.notification.TargetObjectName>();
        if (mappedString.getTargetObjectName() != null) {
            for (TargetObjectName targetObjectName : mappedString.getTargetObjectName().values()) {
                org.opendaylight.yang.gen.v1.urn.onf.otcc.yang.tapi.notification.rev181210.notification.TargetObjectName transTargetObjName = new TargetObjectNameBuilder((NameAndValue)targetObjectName).build();
                targetObjNameMap.put(transTargetObjName.key(), transTargetObjName);
            }
        }
        LOG.info("Notification uuid = {}", (Object)mappedString.getUuid().getValue());
        return new NotificationBuilder().setAlarmInfo(mappedString.getAlarmInfo() == null ? null : new AlarmInfoBuilder((AlarmInfo)mappedString.getAlarmInfo()).build()).setAdditionalText(mappedString.getAdditionalText()).setAdditionalInfo(addInfoMap).setNotificationType(mappedString.getNotificationType()).setChangedAttributes(changedAttMap).setEventTimeStamp(mappedString.getEventTimeStamp()).setLayerProtocolName(mappedString.getLayerProtocolName()).setName(nameMap).setSequenceNumber(mappedString.getSequenceNumber()).setSourceIndicator(mappedString.getSourceIndicator()).setTargetObjectIdentifier(mappedString.getTargetObjectIdentifier()).setTargetObjectName(targetObjNameMap).setTargetObjectType(mappedString.getTargetObjectType()).setTcaInfo(mappedString.getTcaInfo() == null ? null : new TcaInfoBuilder((TcaInfo)mappedString.getTcaInfo()).build()).setUuid(mappedString.getUuid()).build();
    }
}

