/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.transportpce.nbinotifications.serialization;

import java.nio.charset.StandardCharsets;
import java.util.Map;
import org.apache.kafka.common.serialization.Deserializer;
import org.opendaylight.transportpce.common.converter.JsonStringConverter;
import org.opendaylight.yang.gen.v1.nbi.notifications.rev211013.NotificationProcessService;
import org.opendaylight.yang.gen.v1.nbi.notifications.rev211013.get.notifications.process.service.output.NotificationsProcessService;
import org.opendaylight.yang.gen.v1.nbi.notifications.rev211013.get.notifications.process.service.output.NotificationsProcessServiceBuilder;
import org.opendaylight.yangtools.yang.common.QName;
import org.opendaylight.yangtools.yang.data.api.YangInstanceIdentifier;
import org.opendaylight.yangtools.yang.data.codec.gson.JSONCodecFactorySupplier;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NotificationServiceDeserializer
implements Deserializer<NotificationsProcessService> {
    private static final Logger LOG = LoggerFactory.getLogger(NotificationServiceDeserializer.class);
    private JsonStringConverter<NotificationProcessService> converter;

    public void configure(Map<String, ?> configs, boolean isKey) {
        LOG.info("Deserializer configuration {}", configs);
        if (configs.containsKey("converter") && configs.get("converter") instanceof JsonStringConverter) {
            this.converter = (JsonStringConverter)configs.get("converter");
        }
    }

    public NotificationsProcessService deserialize(String topic, byte[] data) {
        if (this.converter == null) {
            throw new IllegalArgumentException("Converter should be configured through configure method of deserializer");
        }
        String value = new String(data, StandardCharsets.UTF_8);
        NotificationProcessService mappedString = (NotificationProcessService)this.converter.createDataObjectFromJsonString(YangInstanceIdentifier.of((QName)NotificationProcessService.QNAME), value, JSONCodecFactorySupplier.RFC7951);
        if (mappedString == null) {
            return null;
        }
        LOG.info("Reading event {}", (Object)mappedString);
        return new NotificationsProcessServiceBuilder().setCommonId(mappedString.getCommonId()).setConnectionType(mappedString.getConnectionType()).setMessage(mappedString.getMessage()).setOperationalState(mappedString.getOperationalState()).setResponseFailed(mappedString.getResponseFailed()).setServiceName(mappedString.getServiceName()).setServiceAEnd(mappedString.getServiceAEnd()).setServiceZEnd(mappedString.getServiceZEnd()).build();
    }
}

