/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.transportpce.nbinotifications.listener;

import java.util.HashMap;
import java.util.Map;
import org.opendaylight.transportpce.nbinotifications.producer.Publisher;
import org.opendaylight.yang.gen.v1.nbi.notifications.rev211013.NbiNotificationsListener;
import org.opendaylight.yang.gen.v1.nbi.notifications.rev211013.NotificationAlarmService;
import org.opendaylight.yang.gen.v1.nbi.notifications.rev211013.NotificationAlarmServiceBuilder;
import org.opendaylight.yang.gen.v1.nbi.notifications.rev211013.NotificationProcessService;
import org.opendaylight.yang.gen.v1.nbi.notifications.rev211013.NotificationProcessServiceBuilder;
import org.opendaylight.yang.gen.v1.nbi.notifications.rev211013.NotificationTapiService;
import org.opendaylight.yang.gen.v1.nbi.notifications.rev211013.NotificationTapiServiceBuilder;
import org.opendaylight.yang.gen.v1.nbi.notifications.rev211013.PublishNotificationAlarmService;
import org.opendaylight.yang.gen.v1.nbi.notifications.rev211013.PublishNotificationProcessService;
import org.opendaylight.yang.gen.v1.nbi.notifications.rev211013.PublishTapiNotificationService;
import org.opendaylight.yang.gen.v1.nbi.notifications.rev211013.notification.tapi.service.AdditionalInfo;
import org.opendaylight.yang.gen.v1.nbi.notifications.rev211013.notification.tapi.service.AdditionalInfoBuilder;
import org.opendaylight.yang.gen.v1.nbi.notifications.rev211013.notification.tapi.service.AdditionalInfoKey;
import org.opendaylight.yang.gen.v1.nbi.notifications.rev211013.notification.tapi.service.AlarmInfoBuilder;
import org.opendaylight.yang.gen.v1.nbi.notifications.rev211013.notification.tapi.service.ChangedAttributes;
import org.opendaylight.yang.gen.v1.nbi.notifications.rev211013.notification.tapi.service.ChangedAttributesBuilder;
import org.opendaylight.yang.gen.v1.nbi.notifications.rev211013.notification.tapi.service.ChangedAttributesKey;
import org.opendaylight.yang.gen.v1.nbi.notifications.rev211013.notification.tapi.service.TargetObjectName;
import org.opendaylight.yang.gen.v1.nbi.notifications.rev211013.notification.tapi.service.TargetObjectNameBuilder;
import org.opendaylight.yang.gen.v1.nbi.notifications.rev211013.notification.tapi.service.TargetObjectNameKey;
import org.opendaylight.yang.gen.v1.nbi.notifications.rev211013.notification.tapi.service.TcaInfoBuilder;
import org.opendaylight.yang.gen.v1.urn.onf.otcc.yang.tapi.common.rev181210.NameAndValue;
import org.opendaylight.yang.gen.v1.urn.onf.otcc.yang.tapi.common.rev181210.global._class.Name;
import org.opendaylight.yang.gen.v1.urn.onf.otcc.yang.tapi.common.rev181210.global._class.NameBuilder;
import org.opendaylight.yang.gen.v1.urn.onf.otcc.yang.tapi.common.rev181210.global._class.NameKey;
import org.opendaylight.yang.gen.v1.urn.onf.otcc.yang.tapi.notification.rev181210.AlarmInfo;
import org.opendaylight.yang.gen.v1.urn.onf.otcc.yang.tapi.notification.rev181210.NameAndValueChange;
import org.opendaylight.yang.gen.v1.urn.onf.otcc.yang.tapi.notification.rev181210.TcaInfo;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NbiNotificationsListenerImpl
implements NbiNotificationsListener {
    private static final Logger LOG = LoggerFactory.getLogger(NbiNotificationsListenerImpl.class);
    private Map<String, Publisher<NotificationProcessService>> publishersServiceMap;
    private Map<String, Publisher<NotificationAlarmService>> publishersAlarmMap;
    private Map<String, Publisher<NotificationTapiService>> tapiPublisherMap;

    public NbiNotificationsListenerImpl(Map<String, Publisher<NotificationProcessService>> publishersServiceMap, Map<String, Publisher<NotificationAlarmService>> publishersAlarmMap, Map<String, Publisher<NotificationTapiService>> tapiPublisherMap) {
        this.publishersServiceMap = publishersServiceMap;
        this.publishersAlarmMap = publishersAlarmMap;
        this.tapiPublisherMap = tapiPublisherMap;
    }

    public void onPublishNotificationProcessService(PublishNotificationProcessService notification) {
        LOG.info("Receiving request for publishing notification service");
        String publisherName = notification.getPublisherName();
        if (!this.publishersServiceMap.containsKey(publisherName)) {
            LOG.error("Unknown publisher {}", (Object)publisherName);
            return;
        }
        Publisher<NotificationProcessService> publisher = this.publishersServiceMap.get(publisherName);
        publisher.sendEvent(new NotificationProcessServiceBuilder().setCommonId(notification.getCommonId()).setConnectionType(notification.getConnectionType()).setMessage(notification.getMessage()).setOperationalState(notification.getOperationalState()).setResponseFailed(notification.getResponseFailed()).setServiceAEnd(notification.getServiceAEnd()).setServiceName(notification.getServiceName()).setServiceZEnd(notification.getServiceZEnd()).build(), notification.getConnectionType().getName());
    }

    public void onPublishNotificationAlarmService(PublishNotificationAlarmService notification) {
        LOG.info("Receiving request for publishing notification alarm service");
        String publisherName = notification.getPublisherName();
        if (!this.publishersAlarmMap.containsKey(publisherName)) {
            LOG.error("Unknown topic {}", (Object)publisherName);
            return;
        }
        Publisher<NotificationAlarmService> publisherAlarm = this.publishersAlarmMap.get(publisherName);
        publisherAlarm.sendEvent(new NotificationAlarmServiceBuilder().setConnectionType(notification.getConnectionType()).setMessage(notification.getMessage()).setOperationalState(notification.getOperationalState()).setServiceName(notification.getServiceName()).build(), "alarm" + notification.getConnectionType().getName());
    }

    public void onPublishTapiNotificationService(PublishTapiNotificationService notification) {
        LOG.info("Receiving request for publishing TAPI notification");
        String topic = notification.getTopic();
        if (!this.tapiPublisherMap.containsKey(topic)) {
            LOG.error("Unknown topic {}", (Object)topic);
            return;
        }
        Publisher<NotificationTapiService> publisher = this.tapiPublisherMap.get(topic);
        publisher.sendEvent(new NotificationTapiServiceBuilder(this.transformTapiNotification(notification)).build(), topic);
    }

    private NotificationTapiService transformTapiNotification(PublishTapiNotificationService notification) {
        HashMap<AdditionalInfoKey, AdditionalInfo> addInfoMap = new HashMap<AdditionalInfoKey, AdditionalInfo>();
        if (notification.getAdditionalInfo() != null) {
            for (Object addInfo : notification.getAdditionalInfo().values()) {
                AdditionalInfo transAddInfo = new AdditionalInfoBuilder((NameAndValue)addInfo).build();
                addInfoMap.put(transAddInfo.key(), transAddInfo);
            }
        }
        HashMap<ChangedAttributesKey, ChangedAttributes> changedAttMap = new HashMap<ChangedAttributesKey, ChangedAttributes>();
        if (notification.getChangedAttributes() != null) {
            for (Object changedAtt : notification.getChangedAttributes().values()) {
                ChangedAttributes transChangedAtt = new ChangedAttributesBuilder((NameAndValueChange)changedAtt).build();
                changedAttMap.put(transChangedAtt.key(), transChangedAtt);
            }
        }
        HashMap<NameKey, Name> nameMap = new HashMap<NameKey, Name>();
        if (notification.getName() != null) {
            for (Name name : notification.getName().values()) {
                Name transName = new NameBuilder(name).build();
                nameMap.put(transName.key(), transName);
            }
        }
        HashMap<TargetObjectNameKey, TargetObjectName> targetObjNameMap = new HashMap<TargetObjectNameKey, TargetObjectName>();
        if (notification.getTargetObjectName() != null) {
            for (org.opendaylight.yang.gen.v1.urn.onf.otcc.yang.tapi.notification.rev181210.notification.TargetObjectName targetObjectName : notification.getTargetObjectName().values()) {
                TargetObjectName transTargetObjName = new TargetObjectNameBuilder((NameAndValue)targetObjectName).build();
                targetObjNameMap.put(transTargetObjName.key(), transTargetObjName);
            }
        }
        LOG.info("Notification uuid = {}", (Object)notification.getUuid());
        return new NotificationTapiServiceBuilder().setAlarmInfo(notification.getAlarmInfo() == null ? null : new AlarmInfoBuilder((AlarmInfo)notification.getAlarmInfo()).build()).setAdditionalText(notification.getAdditionalText()).setAdditionalInfo(addInfoMap).setNotificationType(notification.getNotificationType()).setChangedAttributes(changedAttMap).setEventTimeStamp(notification.getEventTimeStamp()).setLayerProtocolName(notification.getLayerProtocolName()).setName(nameMap).setSequenceNumber(notification.getSequenceNumber()).setSourceIndicator(notification.getSourceIndicator()).setTargetObjectIdentifier(notification.getTargetObjectIdentifier()).setTargetObjectName(targetObjNameMap).setTargetObjectType(notification.getTargetObjectType()).setTcaInfo(notification.getTcaInfo() == null ? null : new TcaInfoBuilder((TcaInfo)notification.getTcaInfo()).build()).setUuid(notification.getUuid()).build();
    }

    public void setPublishersServiceMap(Map<String, Publisher<NotificationProcessService>> publishersServiceMap) {
        this.publishersServiceMap = publishersServiceMap;
    }

    public void setPublishersAlarmMap(Map<String, Publisher<NotificationAlarmService>> publishersAlarmMap) {
        this.publishersAlarmMap = publishersAlarmMap;
    }

    public void setTapiPublishersMap(Map<String, Publisher<NotificationTapiService>> tapiPublishersMap) {
        this.tapiPublisherMap = tapiPublishersMap;
    }
}

