/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.transportpce.nbinotifications.serialization;

import java.nio.charset.StandardCharsets;
import java.util.Map;
import org.apache.kafka.common.serialization.Deserializer;
import org.opendaylight.transportpce.common.converter.JsonStringConverter;
import org.opendaylight.yang.gen.v1.nbi.notifications.rev210813.NotificationAlarmService;
import org.opendaylight.yang.gen.v1.nbi.notifications.rev210813.get.notifications.alarm.service.output.NotificationsAlarmService;
import org.opendaylight.yang.gen.v1.nbi.notifications.rev210813.get.notifications.alarm.service.output.NotificationsAlarmServiceBuilder;
import org.opendaylight.yangtools.yang.common.QName;
import org.opendaylight.yangtools.yang.data.api.YangInstanceIdentifier;
import org.opendaylight.yangtools.yang.data.codec.gson.JSONCodecFactorySupplier;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NotificationAlarmServiceDeserializer
implements Deserializer<NotificationsAlarmService> {
    private static final Logger LOG = LoggerFactory.getLogger(NotificationAlarmServiceDeserializer.class);
    private JsonStringConverter<NotificationAlarmService> converter;

    public void configure(Map<String, ?> configs, boolean isKey) {
        LOG.info("Deserializer configuration {}", configs);
        if (configs.containsKey("converter") && configs.get("converter") instanceof JsonStringConverter) {
            this.converter = (JsonStringConverter)configs.get("converter");
        }
    }

    public NotificationsAlarmService deserialize(String topic, byte[] data) {
        if (this.converter == null) {
            throw new IllegalArgumentException("Converter should be configured through configure method of deserializer");
        }
        String value = new String(data, StandardCharsets.UTF_8);
        NotificationAlarmService mappedString = (NotificationAlarmService)this.converter.createDataObjectFromJsonString(YangInstanceIdentifier.of((QName)NotificationAlarmService.QNAME), value, JSONCodecFactorySupplier.RFC7951);
        if (mappedString == null) {
            return null;
        }
        LOG.info("Reading event {}", (Object)mappedString);
        return new NotificationsAlarmServiceBuilder().setConnectionType(mappedString.getConnectionType()).setMessage(mappedString.getMessage()).setOperationalState(mappedString.getOperationalState()).setServiceName(mappedString.getServiceName()).build();
    }
}

