/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.transportpce.nbinotifications.producer;

import com.google.common.annotations.VisibleForTesting;
import java.util.Properties;
import org.apache.kafka.clients.producer.KafkaProducer;
import org.apache.kafka.clients.producer.Producer;
import org.apache.kafka.clients.producer.ProducerRecord;
import org.apache.kafka.common.serialization.StringSerializer;
import org.opendaylight.transportpce.common.converter.JsonStringConverter;
import org.opendaylight.transportpce.nbinotifications.utils.NbiNotificationsUtils;
import org.opendaylight.yangtools.yang.binding.DataObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Publisher<T extends DataObject> {
    private static final Logger LOG = LoggerFactory.getLogger(Publisher.class);
    private final String id;
    private final Producer<String, T> producer;

    public Publisher(String id, String publisherServer, JsonStringConverter<T> serializer, Class<?> serializerConf) {
        Properties properties = NbiNotificationsUtils.loadProperties("publisher.properties");
        properties.put("client.id", id);
        if (publisherServer != null && !publisherServer.isBlank()) {
            properties.put("bootstrap.servers", publisherServer);
        }
        properties.put("key.serializer", StringSerializer.class);
        properties.put("value.serializer", serializerConf);
        properties.put("converter", serializer);
        LOG.info("Creation publisher for id {} with properties {}", (Object)id, (Object)properties);
        this.producer = new KafkaProducer(properties);
        this.id = id;
    }

    @VisibleForTesting
    Publisher(String id, Producer<String, T> producer) {
        this.producer = producer;
        this.id = id;
    }

    public void close() {
        this.producer.close();
    }

    public void sendEvent(T notification, String topic) {
        LOG.info("SendEvent request to topic '{}' ", (Object)topic);
        this.producer.send(new ProducerRecord(topic, (Object)this.id, notification));
        this.producer.flush();
    }
}

