/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.transportpce.nbinotifications.listener;

import java.util.Map;
import org.opendaylight.transportpce.nbinotifications.producer.Publisher;
import org.opendaylight.yang.gen.v1.nbi.notifications.rev210813.NbiNotificationsListener;
import org.opendaylight.yang.gen.v1.nbi.notifications.rev210813.NotificationAlarmService;
import org.opendaylight.yang.gen.v1.nbi.notifications.rev210813.NotificationAlarmServiceBuilder;
import org.opendaylight.yang.gen.v1.nbi.notifications.rev210813.NotificationProcessService;
import org.opendaylight.yang.gen.v1.nbi.notifications.rev210813.NotificationProcessServiceBuilder;
import org.opendaylight.yang.gen.v1.nbi.notifications.rev210813.PublishNotificationAlarmService;
import org.opendaylight.yang.gen.v1.nbi.notifications.rev210813.PublishNotificationProcessService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NbiNotificationsListenerImpl
implements NbiNotificationsListener {
    private static final Logger LOG = LoggerFactory.getLogger(NbiNotificationsListenerImpl.class);
    private final Map<String, Publisher<NotificationProcessService>> publishersServiceMap;
    private final Map<String, Publisher<NotificationAlarmService>> publishersAlarmMap;

    public NbiNotificationsListenerImpl(Map<String, Publisher<NotificationProcessService>> publishersServiceMap, Map<String, Publisher<NotificationAlarmService>> publishersAlarmMap) {
        this.publishersServiceMap = publishersServiceMap;
        this.publishersAlarmMap = publishersAlarmMap;
    }

    public void onPublishNotificationProcessService(PublishNotificationProcessService notification) {
        LOG.info("Receiving request for publishing notification service");
        String publisherName = notification.getPublisherName();
        if (!this.publishersServiceMap.containsKey(publisherName)) {
            LOG.error("Unknown publisher {}", (Object)publisherName);
            return;
        }
        Publisher<NotificationProcessService> publisher = this.publishersServiceMap.get(publisherName);
        publisher.sendEvent(new NotificationProcessServiceBuilder().setCommonId(notification.getCommonId()).setConnectionType(notification.getConnectionType()).setMessage(notification.getMessage()).setOperationalState(notification.getOperationalState()).setResponseFailed(notification.getResponseFailed()).setServiceAEnd(notification.getServiceAEnd()).setServiceName(notification.getServiceName()).setServiceZEnd(notification.getServiceZEnd()).build(), notification.getConnectionType().getName());
    }

    public void onPublishNotificationAlarmService(PublishNotificationAlarmService notification) {
        LOG.info("Receiving request for publishing notification alarm service");
        String publisherName = notification.getPublisherName();
        if (!this.publishersAlarmMap.containsKey(publisherName)) {
            LOG.error("Unknown topic {}", (Object)publisherName);
            return;
        }
        Publisher<NotificationAlarmService> publisherAlarm = this.publishersAlarmMap.get(publisherName);
        publisherAlarm.sendEvent(new NotificationAlarmServiceBuilder().setConnectionType(notification.getConnectionType()).setMessage(notification.getMessage()).setOperationalState(notification.getOperationalState()).setServiceName(notification.getServiceName()).build(), "alarm" + notification.getConnectionType().getName());
    }
}

