/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.transportpce.nbinotifications.impl;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.opendaylight.mdsal.binding.api.NotificationService;
import org.opendaylight.mdsal.binding.api.RpcProviderService;
import org.opendaylight.mdsal.binding.dom.codec.spi.BindingDOMCodecServices;
import org.opendaylight.transportpce.common.converter.JsonStringConverter;
import org.opendaylight.transportpce.nbinotifications.impl.NbiNotificationsImpl;
import org.opendaylight.transportpce.nbinotifications.listener.NbiNotificationsListenerImpl;
import org.opendaylight.transportpce.nbinotifications.producer.Publisher;
import org.opendaylight.transportpce.nbinotifications.serialization.NotificationAlarmServiceSerializer;
import org.opendaylight.transportpce.nbinotifications.serialization.NotificationServiceSerializer;
import org.opendaylight.yang.gen.v1.nbi.notifications.rev210813.NbiNotificationsListener;
import org.opendaylight.yang.gen.v1.nbi.notifications.rev210813.NbiNotificationsService;
import org.opendaylight.yang.gen.v1.nbi.notifications.rev210813.NotificationAlarmService;
import org.opendaylight.yang.gen.v1.nbi.notifications.rev210813.NotificationProcessService;
import org.opendaylight.yangtools.concepts.ListenerRegistration;
import org.opendaylight.yangtools.concepts.ObjectRegistration;
import org.opendaylight.yangtools.yang.binding.NotificationListener;
import org.opendaylight.yangtools.yang.binding.RpcService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NbiNotificationsProvider {
    private static final Logger LOG = LoggerFactory.getLogger(NbiNotificationsProvider.class);
    private static Map<String, Publisher<NotificationProcessService>> publishersServiceMap = new HashMap<String, Publisher<NotificationProcessService>>();
    private static Map<String, Publisher<NotificationAlarmService>> publishersAlarmMap = new HashMap<String, Publisher<NotificationAlarmService>>();
    private final RpcProviderService rpcService;
    private final NotificationService notificationService;
    private final JsonStringConverter<NotificationProcessService> converterService;
    private final JsonStringConverter<NotificationAlarmService> converterAlarmService;
    private final String subscriberServer;
    private ObjectRegistration<NbiNotificationsService> rpcRegistration;
    private ListenerRegistration<NbiNotificationsListener> listenerRegistration;

    public NbiNotificationsProvider(List<String> publishersService, List<String> publishersAlarm, String subscriberServer, String publisherServer, RpcProviderService rpcProviderService, NotificationService notificationService, BindingDOMCodecServices bindingDOMCodecServices) {
        this.rpcService = rpcProviderService;
        this.notificationService = notificationService;
        this.converterService = new JsonStringConverter(bindingDOMCodecServices);
        for (String publisherService : publishersService) {
            LOG.info("Creating publisher for the following class {}", (Object)publisherService);
            publishersServiceMap.put(publisherService, new Publisher<NotificationProcessService>(publisherService, publisherServer, this.converterService, NotificationServiceSerializer.class));
        }
        this.converterAlarmService = new JsonStringConverter(bindingDOMCodecServices);
        for (String publisherAlarm : publishersAlarm) {
            LOG.info("Creating publisher for the following class {}", (Object)publisherAlarm);
            publishersAlarmMap.put(publisherAlarm, new Publisher<NotificationAlarmService>(publisherAlarm, publisherServer, this.converterAlarmService, NotificationAlarmServiceSerializer.class));
        }
        this.subscriberServer = subscriberServer;
    }

    public void init() {
        LOG.info("NbiNotificationsProvider Session Initiated");
        this.rpcRegistration = this.rpcService.registerRpcImplementation(NbiNotificationsService.class, (RpcService)new NbiNotificationsImpl(this.converterService, this.converterAlarmService, this.subscriberServer));
        this.listenerRegistration = this.notificationService.registerNotificationListener((NotificationListener)new NbiNotificationsListenerImpl(publishersServiceMap, publishersAlarmMap));
    }

    public void close() {
        for (Publisher<NotificationProcessService> publisher : publishersServiceMap.values()) {
            publisher.close();
        }
        for (Publisher<NotificationProcessService> publisher : publishersAlarmMap.values()) {
            publisher.close();
        }
        this.rpcRegistration.close();
        this.listenerRegistration.close();
        LOG.info("NbiNotificationsProvider Closed");
    }
}

