/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.transportpce.nbinotifications.consumer;

import com.google.common.annotations.VisibleForTesting;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Properties;
import org.apache.kafka.clients.consumer.Consumer;
import org.apache.kafka.clients.consumer.ConsumerRecord;
import org.apache.kafka.clients.consumer.ConsumerRecords;
import org.apache.kafka.clients.consumer.KafkaConsumer;
import org.apache.kafka.common.serialization.StringDeserializer;
import org.eclipse.jdt.annotation.NonNull;
import org.opendaylight.transportpce.common.converter.JsonStringConverter;
import org.opendaylight.transportpce.nbinotifications.utils.NbiNotificationsUtils;
import org.opendaylight.yangtools.yang.binding.DataObject;
import org.opendaylight.yangtools.yang.common.QName;
import org.opendaylight.yangtools.yang.data.api.YangInstanceIdentifier;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Subscriber<T extends DataObject, D> {
    private static final Logger LOG = LoggerFactory.getLogger(Subscriber.class);
    private final Consumer<String, D> consumer;

    public Subscriber(String id, String groupId, String subscriberServer, JsonStringConverter<T> deserializer, Class<?> deserializerConf) {
        Properties propsConsumer = NbiNotificationsUtils.loadProperties("subscriber.properties");
        propsConsumer.put("group.id", groupId);
        propsConsumer.put("client.id", id);
        propsConsumer.put("key.deserializer", StringDeserializer.class);
        propsConsumer.put("value.deserializer", deserializerConf);
        propsConsumer.put("converter", deserializer);
        if (subscriberServer != null && !subscriberServer.isBlank()) {
            propsConsumer.put("bootstrap.servers", subscriberServer);
        }
        LOG.info("Subscribing for group id {}, client config id {} with properties {}", new Object[]{groupId, id, propsConsumer});
        this.consumer = new KafkaConsumer(propsConsumer);
    }

    public List<D> subscribe(String topicName, @NonNull QName name) {
        LOG.info("Subscribe request to topic '{}' ", (Object)topicName);
        this.consumer.subscribe(Collections.singleton(topicName));
        ConsumerRecords consumerRecords = this.consumer.poll(Duration.ofMillis(1000L));
        ArrayList<Object> notificationServiceList = new ArrayList<Object>();
        YangInstanceIdentifier.of((QName)name);
        for (ConsumerRecord record : consumerRecords) {
            if (record.value() == null) continue;
            notificationServiceList.add(record.value());
        }
        LOG.info("Getting records '{}' ", notificationServiceList);
        this.consumer.unsubscribe();
        this.consumer.close();
        return notificationServiceList;
    }

    @VisibleForTesting
    public Subscriber(Consumer<String, D> consumer) {
        this.consumer = consumer;
    }
}

