/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.transportpce.nbinotifications.impl;

import com.google.common.util.concurrent.ListenableFuture;
import java.util.List;
import org.opendaylight.transportpce.common.converter.JsonStringConverter;
import org.opendaylight.transportpce.nbinotifications.consumer.Subscriber;
import org.opendaylight.yang.gen.v1.nbi.notifications.rev201130.GetNotificationsServiceInput;
import org.opendaylight.yang.gen.v1.nbi.notifications.rev201130.GetNotificationsServiceOutput;
import org.opendaylight.yang.gen.v1.nbi.notifications.rev201130.GetNotificationsServiceOutputBuilder;
import org.opendaylight.yang.gen.v1.nbi.notifications.rev201130.NbiNotificationsService;
import org.opendaylight.yang.gen.v1.nbi.notifications.rev201130.NotificationService;
import org.opendaylight.yangtools.yang.common.RpcResult;
import org.opendaylight.yangtools.yang.common.RpcResultBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NbiNotificationsImpl
implements NbiNotificationsService {
    private static final Logger LOG = LoggerFactory.getLogger(NbiNotificationsImpl.class);
    private final JsonStringConverter<NotificationService> converter;
    private final String server;

    public NbiNotificationsImpl(JsonStringConverter<NotificationService> converter, String server) {
        this.converter = converter;
        this.server = server;
    }

    public ListenableFuture<RpcResult<GetNotificationsServiceOutput>> getNotificationsService(GetNotificationsServiceInput input) {
        LOG.info("RPC getNotificationsService received");
        if (input == null || input.getIdConsumer() == null || input.getGroupId() == null) {
            LOG.warn("Missing mandatory params for input {}", (Object)input);
            return RpcResultBuilder.success((Object)new GetNotificationsServiceOutputBuilder().build()).buildFuture();
        }
        Subscriber subscriber = new Subscriber(input.getIdConsumer(), input.getGroupId(), this.server, this.converter);
        List<org.opendaylight.yang.gen.v1.nbi.notifications.rev201130.get.notifications.service.output.NotificationService> notificationServiceList = subscriber.subscribeService(input.getConnectionType().getName());
        GetNotificationsServiceOutputBuilder output = new GetNotificationsServiceOutputBuilder().setNotificationService(notificationServiceList);
        return RpcResultBuilder.success((Object)output.build()).buildFuture();
    }
}

