/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.transportpce.nbinotifications.consumer;

import com.google.common.annotations.VisibleForTesting;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Properties;
import org.apache.kafka.clients.consumer.Consumer;
import org.apache.kafka.clients.consumer.ConsumerRecord;
import org.apache.kafka.clients.consumer.ConsumerRecords;
import org.apache.kafka.clients.consumer.KafkaConsumer;
import org.apache.kafka.common.serialization.StringDeserializer;
import org.opendaylight.transportpce.common.converter.JsonStringConverter;
import org.opendaylight.transportpce.nbinotifications.serialization.NotificationServiceDeserializer;
import org.opendaylight.transportpce.nbinotifications.utils.NbiNotificationsUtils;
import org.opendaylight.yang.gen.v1.nbi.notifications.rev201130.NotificationService;
import org.opendaylight.yangtools.yang.common.QName;
import org.opendaylight.yangtools.yang.data.api.YangInstanceIdentifier;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Subscriber {
    private static final Logger LOG = LoggerFactory.getLogger(Subscriber.class);
    private final Consumer<String, org.opendaylight.yang.gen.v1.nbi.notifications.rev201130.get.notifications.service.output.NotificationService> consumer;

    public Subscriber(String id, String groupId, String suscriberServer, JsonStringConverter<NotificationService> deserializer) {
        Properties propsConsumer = NbiNotificationsUtils.loadProperties("subscriber.properties");
        propsConsumer.put("group.id", groupId);
        propsConsumer.put("client.id", id);
        propsConsumer.put("key.deserializer", StringDeserializer.class);
        propsConsumer.put("value.deserializer", NotificationServiceDeserializer.class);
        propsConsumer.put("converter", deserializer);
        if (suscriberServer != null && !suscriberServer.isBlank()) {
            propsConsumer.put("bootstrap.servers", suscriberServer);
        }
        LOG.info("Suscribing for group id {}, client config id {} with properties {}", new Object[]{groupId, id, propsConsumer});
        this.consumer = new KafkaConsumer(propsConsumer);
    }

    public List<org.opendaylight.yang.gen.v1.nbi.notifications.rev201130.get.notifications.service.output.NotificationService> subscribeService(String topicName) {
        LOG.info("Subscribe request to topic '{}' ", (Object)topicName);
        this.consumer.subscribe(Collections.singleton(topicName));
        ConsumerRecords consumerRecords = this.consumer.poll(Duration.ofMillis(1000L));
        ArrayList<org.opendaylight.yang.gen.v1.nbi.notifications.rev201130.get.notifications.service.output.NotificationService> notificationServiceList = new ArrayList<org.opendaylight.yang.gen.v1.nbi.notifications.rev201130.get.notifications.service.output.NotificationService>();
        YangInstanceIdentifier.of((QName)org.opendaylight.yang.gen.v1.nbi.notifications.rev201130.get.notifications.service.output.NotificationService.QNAME);
        for (ConsumerRecord record : consumerRecords) {
            if (record.value() == null) continue;
            notificationServiceList.add((org.opendaylight.yang.gen.v1.nbi.notifications.rev201130.get.notifications.service.output.NotificationService)record.value());
        }
        LOG.info("Getting records '{}' ", notificationServiceList);
        this.consumer.unsubscribe();
        this.consumer.close();
        return notificationServiceList;
    }

    @VisibleForTesting
    public Subscriber(Consumer<String, org.opendaylight.yang.gen.v1.nbi.notifications.rev201130.get.notifications.service.output.NotificationService> consumer) {
        this.consumer = consumer;
    }
}

