/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.transportpce.nbinotifications.serialization;

import java.nio.charset.StandardCharsets;
import java.util.Map;
import org.apache.kafka.common.serialization.Deserializer;
import org.opendaylight.transportpce.common.converter.JsonStringConverter;
import org.opendaylight.yang.gen.v1.nbi.notifications.rev201130.NotificationService;
import org.opendaylight.yang.gen.v1.nbi.notifications.rev201130.get.notifications.service.output.NotificationServiceBuilder;
import org.opendaylight.yangtools.yang.common.QName;
import org.opendaylight.yangtools.yang.data.api.YangInstanceIdentifier;
import org.opendaylight.yangtools.yang.data.codec.gson.JSONCodecFactorySupplier;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NotificationServiceDeserializer
implements Deserializer<org.opendaylight.yang.gen.v1.nbi.notifications.rev201130.get.notifications.service.output.NotificationService> {
    private static final Logger LOG = LoggerFactory.getLogger(NotificationServiceDeserializer.class);
    private JsonStringConverter<NotificationService> converter;

    public void configure(Map<String, ?> configs, boolean isKey) {
        LOG.info("Deserializer configuration {}", configs);
        if (configs.containsKey("converter") && configs.get("converter") instanceof JsonStringConverter) {
            this.converter = (JsonStringConverter)configs.get("converter");
        }
    }

    public org.opendaylight.yang.gen.v1.nbi.notifications.rev201130.get.notifications.service.output.NotificationService deserialize(String topic, byte[] data) {
        if (this.converter == null) {
            throw new IllegalArgumentException("Converter should be configured through configure method of deserializer");
        }
        String value = new String(data, StandardCharsets.UTF_8);
        NotificationService mappedString = (NotificationService)this.converter.createDataObjectFromJsonString(YangInstanceIdentifier.of((QName)NotificationService.QNAME), value, JSONCodecFactorySupplier.RFC7951);
        if (mappedString != null) {
            LOG.info("Reading event {}", (Object)mappedString);
            return new NotificationServiceBuilder().setCommonId(mappedString.getCommonId()).setConnectionType(mappedString.getConnectionType()).setMessage(mappedString.getMessage()).setOperationalState(mappedString.getOperationalState()).setResponseFailed(mappedString.getResponseFailed()).setServiceName(mappedString.getServiceName()).setServiceAEnd(mappedString.getServiceAEnd()).setServiceZEnd(mappedString.getServiceZEnd()).build();
        }
        return null;
    }
}

