/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.transportpce.nbinotifications.producer;

import com.google.common.annotations.VisibleForTesting;
import java.util.Properties;
import org.apache.kafka.clients.producer.KafkaProducer;
import org.apache.kafka.clients.producer.Producer;
import org.apache.kafka.clients.producer.ProducerRecord;
import org.apache.kafka.common.serialization.StringSerializer;
import org.opendaylight.transportpce.common.converter.JsonStringConverter;
import org.opendaylight.transportpce.nbinotifications.serialization.NotificationServiceSerializer;
import org.opendaylight.transportpce.nbinotifications.utils.NbiNotificationsUtils;
import org.opendaylight.yang.gen.v1.nbi.notifications.rev201130.NotificationService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Publisher {
    private static final Logger LOG = LoggerFactory.getLogger(Publisher.class);
    private final String id;
    private final Producer<String, NotificationService> producer;

    public Publisher(String id, String publisherServer, JsonStringConverter<NotificationService> serializer) {
        Properties properties = NbiNotificationsUtils.loadProperties("publisher.properties");
        properties.put("client.id", id);
        if (publisherServer != null && !publisherServer.isBlank()) {
            properties.put("bootstrap.servers", publisherServer);
        }
        properties.put("key.serializer", StringSerializer.class);
        properties.put("value.serializer", NotificationServiceSerializer.class);
        properties.put("converter", serializer);
        LOG.info("Creationg publisher for id {} with properties {}", (Object)id, (Object)properties);
        this.producer = new KafkaProducer(properties);
        this.id = id;
    }

    @VisibleForTesting
    Publisher(String id, Producer<String, NotificationService> producer) {
        this.producer = producer;
        this.id = id;
    }

    public void close() {
        this.producer.close();
    }

    public void sendEvent(NotificationService notificationService) {
        LOG.info("SendEvent request to topic '{}' ", (Object)notificationService.getConnectionType().getName());
        this.producer.send(new ProducerRecord(notificationService.getConnectionType().getName(), (Object)this.id, (Object)notificationService));
        this.producer.flush();
    }
}

