/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.transportpce.nbinotifications.impl;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.opendaylight.mdsal.binding.api.RpcProviderService;
import org.opendaylight.mdsal.binding.dom.codec.spi.BindingDOMCodecServices;
import org.opendaylight.transportpce.common.converter.JsonStringConverter;
import org.opendaylight.transportpce.nbinotifications.impl.NbiNotificationsImpl;
import org.opendaylight.transportpce.nbinotifications.listener.NbiNotificationsListenerImpl;
import org.opendaylight.transportpce.nbinotifications.producer.Publisher;
import org.opendaylight.yang.gen.v1.nbi.notifications.rev201130.NbiNotificationsListener;
import org.opendaylight.yang.gen.v1.nbi.notifications.rev201130.NbiNotificationsService;
import org.opendaylight.yang.gen.v1.nbi.notifications.rev201130.NotificationService;
import org.opendaylight.yangtools.concepts.ListenerRegistration;
import org.opendaylight.yangtools.concepts.ObjectRegistration;
import org.opendaylight.yangtools.yang.binding.NotificationListener;
import org.opendaylight.yangtools.yang.binding.RpcService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NbiNotificationsProvider {
    private static final Logger LOG = LoggerFactory.getLogger(NbiNotificationsProvider.class);
    private static Map<String, Publisher> publishersMap = new HashMap<String, Publisher>();
    private final RpcProviderService rpcService;
    private ObjectRegistration<NbiNotificationsService> rpcRegistration;
    private ListenerRegistration<NbiNotificationsListener> listenerRegistration;
    private org.opendaylight.mdsal.binding.api.NotificationService notificationService;
    private final JsonStringConverter<NotificationService> converter;
    private final String suscriberServer;

    public NbiNotificationsProvider(List<String> topics, String suscriberServer, String publisherServer, RpcProviderService rpcProviderService, org.opendaylight.mdsal.binding.api.NotificationService notificationService, BindingDOMCodecServices bindingDOMCodecServices) {
        this.rpcService = rpcProviderService;
        this.notificationService = notificationService;
        this.converter = new JsonStringConverter(bindingDOMCodecServices);
        for (String topic : topics) {
            LOG.info("Creating publisher for topic {}", (Object)topic);
            publishersMap.put(topic, new Publisher(topic, publisherServer, this.converter));
        }
        this.suscriberServer = suscriberServer;
    }

    public void init() {
        LOG.info("NbiNotificationsProvider Session Initiated");
        this.rpcRegistration = this.rpcService.registerRpcImplementation(NbiNotificationsService.class, (RpcService)new NbiNotificationsImpl(this.converter, this.suscriberServer));
        this.listenerRegistration = this.notificationService.registerNotificationListener((NotificationListener)new NbiNotificationsListenerImpl(publishersMap));
    }

    public void close() {
        for (Publisher publisher : publishersMap.values()) {
            publisher.close();
        }
        this.rpcRegistration.close();
        this.listenerRegistration.close();
        LOG.info("NbiNotificationsProvider Closed");
    }
}

