package org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.tl1.southbound.impl.rev150608.modules.module.configuration;
import java.util.Collections;
import java.util.Map;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.tl1.southbound.impl.rev150608.modules.module.configuration.tl1.southbound.impl.Broker;
import org.opendaylight.yangtools.yang.binding.DataObject;
import org.opendaylight.yangtools.yang.binding.AugmentationHolder;
import java.util.HashMap;
import org.opendaylight.yangtools.concepts.Builder;
import org.opendaylight.yangtools.yang.binding.Augmentation;


/**
 * Class that builds {@link org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.tl1.southbound.impl.rev150608.modules.module.configuration.Tl1SouthboundImpl} instances.
 *
 * @see org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.tl1.southbound.impl.rev150608.modules.module.configuration.Tl1SouthboundImpl
 *
 */
public class Tl1SouthboundImplBuilder implements Builder <org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.tl1.southbound.impl.rev150608.modules.module.configuration.Tl1SouthboundImpl> {

    private Broker _broker;

    Map<java.lang.Class<? extends Augmentation<org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.tl1.southbound.impl.rev150608.modules.module.configuration.Tl1SouthboundImpl>>, Augmentation<org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.tl1.southbound.impl.rev150608.modules.module.configuration.Tl1SouthboundImpl>> augmentation = Collections.emptyMap();

    public Tl1SouthboundImplBuilder() {
    }

    public Tl1SouthboundImplBuilder(Tl1SouthboundImpl base) {
        this._broker = base.getBroker();
        if (base instanceof Tl1SouthboundImplImpl) {
            Tl1SouthboundImplImpl impl = (Tl1SouthboundImplImpl) base;
            if (!impl.augmentation.isEmpty()) {
                this.augmentation = new HashMap<>(impl.augmentation);
            }
        } else if (base instanceof AugmentationHolder) {
            @SuppressWarnings("unchecked")
            AugmentationHolder<org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.tl1.southbound.impl.rev150608.modules.module.configuration.Tl1SouthboundImpl> casted =(AugmentationHolder<org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.tl1.southbound.impl.rev150608.modules.module.configuration.Tl1SouthboundImpl>) base;
            if (!casted.augmentations().isEmpty()) {
                this.augmentation = new HashMap<>(casted.augmentations());
            }
        }
    }


    public Broker getBroker() {
        return _broker;
    }
    
    @SuppressWarnings("unchecked")
    public <E extends Augmentation<org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.tl1.southbound.impl.rev150608.modules.module.configuration.Tl1SouthboundImpl>> E getAugmentation(java.lang.Class<E> augmentationType) {
        if (augmentationType == null) {
            throw new IllegalArgumentException("Augmentation Type reference cannot be NULL!");
        }
        return (E) augmentation.get(augmentationType);
    }

    public Tl1SouthboundImplBuilder setBroker(Broker value) {
        this._broker = value;
        return this;
    }
    
    public Tl1SouthboundImplBuilder addAugmentation(java.lang.Class<? extends Augmentation<org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.tl1.southbound.impl.rev150608.modules.module.configuration.Tl1SouthboundImpl>> augmentationType, Augmentation<org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.tl1.southbound.impl.rev150608.modules.module.configuration.Tl1SouthboundImpl> augmentation) {
        if (augmentation == null) {
            return removeAugmentation(augmentationType);
        }
    
        if (!(this.augmentation instanceof HashMap)) {
            this.augmentation = new HashMap<>();
        }
    
        this.augmentation.put(augmentationType, augmentation);
        return this;
    }
    
    public Tl1SouthboundImplBuilder removeAugmentation(java.lang.Class<? extends Augmentation<org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.tl1.southbound.impl.rev150608.modules.module.configuration.Tl1SouthboundImpl>> augmentationType) {
        if (this.augmentation instanceof HashMap) {
            this.augmentation.remove(augmentationType);
        }
        return this;
    }

    public Tl1SouthboundImpl build() {
        return new Tl1SouthboundImplImpl(this);
    }

    private static final class Tl1SouthboundImplImpl implements Tl1SouthboundImpl {

        public java.lang.Class<org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.tl1.southbound.impl.rev150608.modules.module.configuration.Tl1SouthboundImpl> getImplementedInterface() {
            return org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.tl1.southbound.impl.rev150608.modules.module.configuration.Tl1SouthboundImpl.class;
        }

        private final Broker _broker;

        private Map<java.lang.Class<? extends Augmentation<org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.tl1.southbound.impl.rev150608.modules.module.configuration.Tl1SouthboundImpl>>, Augmentation<org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.tl1.southbound.impl.rev150608.modules.module.configuration.Tl1SouthboundImpl>> augmentation = Collections.emptyMap();

        private Tl1SouthboundImplImpl(Tl1SouthboundImplBuilder base) {
            this._broker = base.getBroker();
            switch (base.augmentation.size()) {
            case 0:
                this.augmentation = Collections.emptyMap();
                break;
            case 1:
                final Map.Entry<java.lang.Class<? extends Augmentation<org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.tl1.southbound.impl.rev150608.modules.module.configuration.Tl1SouthboundImpl>>, Augmentation<org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.tl1.southbound.impl.rev150608.modules.module.configuration.Tl1SouthboundImpl>> e = base.augmentation.entrySet().iterator().next();
                this.augmentation = Collections.<java.lang.Class<? extends Augmentation<org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.tl1.southbound.impl.rev150608.modules.module.configuration.Tl1SouthboundImpl>>, Augmentation<org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.tl1.southbound.impl.rev150608.modules.module.configuration.Tl1SouthboundImpl>>singletonMap(e.getKey(), e.getValue());
                break;
            default :
                this.augmentation = new HashMap<>(base.augmentation);
            }
        }

        @Override
        public Broker getBroker() {
            return _broker;
        }
        
        @SuppressWarnings("unchecked")
        @Override
        public <E extends Augmentation<org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.tl1.southbound.impl.rev150608.modules.module.configuration.Tl1SouthboundImpl>> E getAugmentation(java.lang.Class<E> augmentationType) {
            if (augmentationType == null) {
                throw new IllegalArgumentException("Augmentation Type reference cannot be NULL!");
            }
            return (E) augmentation.get(augmentationType);
        }

        private int hash = 0;
        private volatile boolean hashValid = false;
        
        @Override
        public int hashCode() {
            if (hashValid) {
                return hash;
            }
        
            final int prime = 31;
            int result = 1;
            result = prime * result + ((_broker == null) ? 0 : _broker.hashCode());
            result = prime * result + ((augmentation == null) ? 0 : augmentation.hashCode());
        
            hash = result;
            hashValid = true;
            return result;
        }

        @Override
        public boolean equals(java.lang.Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof DataObject)) {
                return false;
            }
            if (!org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.tl1.southbound.impl.rev150608.modules.module.configuration.Tl1SouthboundImpl.class.equals(((DataObject)obj).getImplementedInterface())) {
                return false;
            }
            org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.tl1.southbound.impl.rev150608.modules.module.configuration.Tl1SouthboundImpl other = (org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.tl1.southbound.impl.rev150608.modules.module.configuration.Tl1SouthboundImpl)obj;
            if (_broker == null) {
                if (other.getBroker() != null) {
                    return false;
                }
            } else if(!_broker.equals(other.getBroker())) {
                return false;
            }
            if (getClass() == obj.getClass()) {
                // Simple case: we are comparing against self
                Tl1SouthboundImplImpl otherImpl = (Tl1SouthboundImplImpl) obj;
                if (augmentation == null) {
                    if (otherImpl.augmentation != null) {
                        return false;
                    }
                } else if(!augmentation.equals(otherImpl.augmentation)) {
                    return false;
                }
            } else {
                // Hard case: compare our augments with presence there...
                for (Map.Entry<java.lang.Class<? extends Augmentation<org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.tl1.southbound.impl.rev150608.modules.module.configuration.Tl1SouthboundImpl>>, Augmentation<org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.tl1.southbound.impl.rev150608.modules.module.configuration.Tl1SouthboundImpl>> e : augmentation.entrySet()) {
                    if (!e.getValue().equals(other.getAugmentation(e.getKey()))) {
                        return false;
                    }
                }
                // .. and give the other one the chance to do the same
                if (!obj.equals(this)) {
                    return false;
                }
            }
            return true;
        }

        @Override
        public java.lang.String toString() {
            java.lang.StringBuilder builder = new java.lang.StringBuilder ("Tl1SouthboundImpl [");
            boolean first = true;
        
            if (_broker != null) {
                if (first) {
                    first = false;
                } else {
                    builder.append(", ");
                }
                builder.append("_broker=");
                builder.append(_broker);
             }
            if (first) {
                first = false;
            } else {
                builder.append(", ");
            }
            builder.append("augmentation=");
            builder.append(augmentation.values());
            return builder.append(']').toString();
        }
    }

}
