/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.testapp.persistence;

import java.util.List;
import org.opendaylight.persistence.PersistenceException;
import org.opendaylight.persistence.store.ObjectStore;
import org.opendaylight.persistence.util.common.type.Id;
import org.opendaylight.persistence.util.common.type.Sort;
import org.opendaylight.testapp.common.model.NetworkDevice;
import org.opendaylight.testapp.common.model.NetworkDeviceFilter;
import org.opendaylight.testapp.common.model.NetworkDeviceSortKey;
import org.opendaylight.testapp.common.model.TsdrMetric;
import org.opendaylight.testapp.common.model.TsdrMetricFilter;
import org.opendaylight.testapp.common.model.TsdrMetricSortKey;
import org.opendaylight.testapp.common.model.User;
import org.opendaylight.testapp.common.model.UserFilter;
import org.opendaylight.testapp.common.type.SerialNumber;
import org.opendaylight.testapp.common.type.Username;

public interface PersistenceService {
    public NetworkDevicePersistenceService networkDevice();

    public UserPersistenceService user();

    public TsdrMetricPersistenceService tsdrMetric();

    public static interface TsdrMetricPersistenceService
    extends ObjectStore<Long, TsdrMetric, TsdrMetricFilter, TsdrMetricSortKey> {
    }

    public static interface UserPersistenceService
    extends ObjectStore<Username, User, UserFilter, Void> {
        public void store(User var1) throws PersistenceException;

        public User get(Id<User, Username> var1) throws PersistenceException;

        public List<User> find(UserFilter var1) throws PersistenceException;

        public void delete(Id<User, Username> var1) throws PersistenceException;
    }

    public static interface NetworkDevicePersistenceService
    extends ObjectStore<SerialNumber, NetworkDevice, NetworkDeviceFilter, NetworkDeviceSortKey> {
        public void store(NetworkDevice var1) throws PersistenceException;

        public NetworkDevice get(Id<NetworkDevice, SerialNumber> var1) throws PersistenceException;

        public List<NetworkDevice> find(NetworkDeviceFilter var1, List<Sort<NetworkDeviceSortKey>> var2) throws PersistenceException;

        public void delete(Id<NetworkDevice, SerialNumber> var1) throws PersistenceException;
    }
}

