/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.persistence.util.test.easymock;

import javax.annotation.Nonnull;
import javax.annotation.concurrent.NotThreadSafe;
import org.easymock.EasyMock;
import org.easymock.IArgumentMatcher;
import org.opendaylight.persistence.util.test.easymock.Matchable;

@NotThreadSafe
public abstract class ArgumentMatcher<T>
implements IArgumentMatcher {
    private final String name;
    private String mismatchDescription;

    public ArgumentMatcher(@Nonnull String name) {
        this.name = name;
    }

    public void appendTo(StringBuffer buffer) {
        buffer.append('<');
        buffer.append(this.name);
        if (this.mismatchDescription != null) {
            buffer.append(' ');
            buffer.append('[');
            buffer.append(this.mismatchDescription);
            buffer.append(']');
        }
        buffer.append('>');
        this.mismatchDescription = null;
    }

    public boolean matches(Object arg) {
        if (arg == null) {
            return false;
        }
        try {
            Object argument = arg;
            return this.verifyMatch(argument);
        }
        catch (ClassCastException e) {
            return false;
        }
    }

    public abstract boolean verifyMatch(@Nonnull T var1);

    @SafeVarargs
    protected final boolean verify(Matchable<?> ... properties) {
        for (Matchable<?> property : properties) {
            if (property.matches()) continue;
            this.mismatchDescription = property.toString();
            return false;
        }
        return true;
    }

    public T match() {
        return ArgumentMatcher.match(this);
    }

    public static <T> T match(@Nonnull IArgumentMatcher matcher) {
        if (matcher == null) {
            throw new IllegalArgumentException("matcher cannot be null");
        }
        EasyMock.reportMatcher((IArgumentMatcher)matcher);
        return null;
    }
}

