/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.persistence.util.test;

import java.lang.reflect.Field;

public final class TestUtil {
    private static final String ILLEGAL_ARGUMENT_OBJ = "obj cannot be null";
    private static final String ILLEGAL_ARGUMENT_FIELD_NAME_NULL = "fieldName cannot be null";
    private static final String ILLEGAL_ARGUMENT_FIELD_NAME_EMPTY = "fieldName cannot be empty";
    private static final String ILLEGAL_ARGUMENT_DECLARED_FIELD_CLASS = "declaredFieldClass cannot be null";

    private TestUtil() {
    }

    public static <T> void setPrivateField(String fieldName, Object fieldValue, T obj) throws SecurityException, NoSuchFieldException, IllegalArgumentException, IllegalAccessException {
        if (obj == null) {
            throw new IllegalArgumentException(ILLEGAL_ARGUMENT_OBJ);
        }
        Class<?> objClass = obj.getClass();
        TestUtil.setPrivateField(fieldName, fieldValue, obj, objClass);
    }

    public static <T> void setPrivateField(String fieldName, Object fieldValue, T obj, Class<? super T> declaredFieldClass) throws SecurityException, NoSuchFieldException, IllegalArgumentException, IllegalAccessException {
        if (obj == null) {
            throw new IllegalArgumentException(ILLEGAL_ARGUMENT_OBJ);
        }
        if (fieldName == null) {
            throw new IllegalArgumentException(ILLEGAL_ARGUMENT_FIELD_NAME_NULL);
        }
        if (fieldName.isEmpty()) {
            throw new IllegalArgumentException(ILLEGAL_ARGUMENT_FIELD_NAME_EMPTY);
        }
        if (declaredFieldClass == null) {
            throw new IllegalArgumentException(ILLEGAL_ARGUMENT_DECLARED_FIELD_CLASS);
        }
        Field field = declaredFieldClass.getDeclaredField(fieldName);
        field.setAccessible(true);
        field.set(obj, fieldValue);
    }

    public static <T, E> E getPrivateField(String fieldName, T obj) throws SecurityException, NoSuchFieldException, IllegalArgumentException, IllegalAccessException {
        if (obj == null) {
            throw new IllegalArgumentException(ILLEGAL_ARGUMENT_OBJ);
        }
        Class<?> objClass = obj.getClass();
        return TestUtil.getPrivateField(fieldName, obj, objClass);
    }

    public static <T, E> E getPrivateField(String fieldName, T obj, Class<? super T> declaredFieldClass) throws SecurityException, NoSuchFieldException, IllegalArgumentException, IllegalAccessException {
        if (obj == null) {
            throw new IllegalArgumentException(ILLEGAL_ARGUMENT_OBJ);
        }
        if (fieldName == null) {
            throw new IllegalArgumentException(ILLEGAL_ARGUMENT_FIELD_NAME_NULL);
        }
        if (fieldName.isEmpty()) {
            throw new IllegalArgumentException(ILLEGAL_ARGUMENT_FIELD_NAME_EMPTY);
        }
        if (declaredFieldClass == null) {
            throw new IllegalArgumentException(ILLEGAL_ARGUMENT_DECLARED_FIELD_CLASS);
        }
        Field field = declaredFieldClass.getDeclaredField(fieldName);
        field.setAccessible(true);
        return (E)field.get(obj);
    }

    public static StackTraceElement getExecutingMethod() {
        int sourceStackTraceIndex = 2;
        StackTraceElement[] stackTraceElements = Thread.currentThread().getStackTrace();
        if (stackTraceElements.length >= 2) {
            return stackTraceElements[2];
        }
        return null;
    }
}

