/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.persistence.util.test;

import java.util.Random;

public class RandomDataGenerator {
    private Random random = new Random();

    public long getLong() {
        return this.random.nextLong();
    }

    public int getInt() {
        return this.random.nextInt();
    }

    public int getPositiveInt() {
        return this.random.nextInt(Integer.MAX_VALUE);
    }

    public void generateBytes(byte[] bytes) {
        this.random.nextBytes(bytes);
    }

    public boolean getBoolean() {
        return this.random.nextBoolean();
    }

    public <E extends Enum<E>> E getEnum(Class<E> enumClass) throws NullPointerException, IllegalArgumentException {
        Enum[] values = (Enum[])enumClass.getEnumConstants();
        if (values.length == 0) {
            throw new IllegalArgumentException("enum type must define at least one constant");
        }
        int index = Math.abs(this.getInt() % values.length);
        return (E)values[index];
    }
}

