/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.persistence.util.test;

import org.junit.Assert;

public final class EqualityTester {
    private static final DifferetType DIFFERENT_TYPE = new DifferetType();

    private EqualityTester() {
    }

    @SafeVarargs
    public static <T> void testEqualsAndHashCode(T obj, T equal1, T equal2, T ... unequals) {
        EqualityTester.testEqualsAndHashCode(obj, equal1, equal2, null, unequals);
    }

    @SafeVarargs
    public static <T> void testEqualsAndHashCode(T obj, T equal1, T equal2, Exerciser<T> exerciser, T ... unequals) {
        String testedObjectClassName = obj.getClass().getCanonicalName();
        Assert.assertTrue((String)("Reflexive property broken for " + testedObjectClassName), (boolean)obj.equals(obj));
        Assert.assertTrue((String)("Symmetric property broken for " + testedObjectClassName), (obj.equals(equal1) && equal1.equals(obj) ? 1 : 0) != 0);
        Assert.assertTrue((String)("Transitive property broken for " + testedObjectClassName), (obj.equals(equal1) && equal1.equals(equal2) && obj.equals(equal2) ? 1 : 0) != 0);
        Object nullObject = null;
        Assert.assertFalse((String)("Null reference property broken for " + testedObjectClassName), (boolean)obj.equals(nullObject));
        Assert.assertFalse((String)("Different type parameter consideration broken for " + testedObjectClassName), (boolean)obj.equals(DIFFERENT_TYPE));
        if (unequals != null) {
            for (T unequal : unequals) {
                Assert.assertFalse((String)("Inequality test broken for " + testedObjectClassName), (boolean)obj.equals(unequal));
                Assert.assertFalse((String)("Inequality test broken for " + testedObjectClassName), (boolean)unequal.equals(obj));
            }
        }
        Assert.assertEquals((String)("Hashcode broken for " + testedObjectClassName), (long)obj.hashCode(), (long)equal1.hashCode());
        Assert.assertEquals((String)("Hashcode broken for " + testedObjectClassName), (long)obj.hashCode(), (long)equal2.hashCode());
        if (exerciser != null) {
            exerciser.exercise(obj);
        }
        Assert.assertTrue((String)("Consistent property broken for " + testedObjectClassName), (boolean)obj.equals(equal1));
        Assert.assertFalse((String)("Consistent property broken for " + testedObjectClassName), (boolean)obj.equals(unequals));
        Assert.assertEquals((String)("Hashcode consistent property broken for " + testedObjectClassName), (long)obj.hashCode(), (long)equal1.hashCode());
    }

    private static class DifferetType {
        private DifferetType() {
        }
    }

    public static interface Exerciser<T> {
        public void exercise(T var1);
    }
}

