/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.persistence.util.test;

import java.util.Comparator;
import org.junit.Assert;

public final class ComparabilityTester {
    private ComparabilityTester() {
    }

    public static <T extends Comparable<T>> void testComparison(T first, T equallyInOrderToFirst, T second, T third) {
        Comparator comparator = new Comparator<T>(){

            @Override
            public int compare(T o1, T o2) {
                return o1.compareTo(o2);
            }
        };
        ComparabilityTester.testComparison(first, equallyInOrderToFirst, second, third, comparator);
    }

    public static <T> void testComparison(T first, T equallyInOrderToFirst, T second, T third, Comparator<T> comparator) {
        Assert.assertTrue((String)"'Equal to' comparison broken", (comparator.compare(first, equallyInOrderToFirst) == 0 ? 1 : 0) != 0);
        Assert.assertTrue((String)"'Less than' comparison broken", (comparator.compare(first, second) < 0 ? 1 : 0) != 0);
        Assert.assertTrue((String)"'Greater than' comparison broken", (comparator.compare(second, first) > 0 ? 1 : 0) != 0);
        Assert.assertTrue((String)"'Less than' transitive comparison broken", (comparator.compare(first, second) < 0 && comparator.compare(second, third) < 0 && comparator.compare(first, third) < 0 ? 1 : 0) != 0);
        Assert.assertTrue((String)"'Greater than' transitive comparison broken", (comparator.compare(third, second) > 0 && comparator.compare(second, first) > 0 && comparator.compare(third, first) > 0 ? 1 : 0) != 0);
    }
}

