/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.persistence.util.test.easymock;

import com.google.common.base.MoreObjects;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public final class Matchable<T> {
    private final String name;
    private final T expected;
    private final T actual;
    private final boolean matches;

    private Matchable(@Nonnull String name, @Nullable T expected, @Nullable T actual) {
        if (name == null) {
            throw new IllegalArgumentException("name cannot be null");
        }
        if (name.isEmpty()) {
            throw new IllegalArgumentException("name cannot be empty");
        }
        this.name = name;
        this.expected = expected;
        this.actual = actual;
        this.matches = Matchable.matches(expected, actual);
    }

    public static <T> Matchable<T> valueOf(String name, T expected, T actual) {
        return new Matchable<T>(name, expected, actual);
    }

    public boolean matches() {
        return this.matches;
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("name", (Object)this.name).add("expected", this.expected).add("actual", this.actual).toString();
    }

    private static <T> boolean matches(T expected, T actual) {
        return !(expected == null ? actual != null : !expected.equals(actual));
    }
}

