/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.persistence.util.test;

import org.junit.Assert;

public final class ThrowableTester {
    private ThrowableTester() {
    }

    public static <T extends Throwable> void assertAnyThrowableType(Class<T> expected, Throwable actual) {
        Assert.assertTrue((String)("Invalid throwable, expected any <" + expected.getName() + "> but was <" + actual.getClass().getName() + ">"), (boolean)expected.isInstance(actual));
    }

    public static <T extends Throwable> void assertThrowableType(Class<T> expected, Throwable actual) {
        Assert.assertEquals((String)"Invalid throwable,", expected, actual.getClass());
    }

    public static <T extends Throwable> void testThrowsAny(Class<T> expectedThrowable, Instruction instruction) {
        ThrowableTester.testThrowsAny(expectedThrowable, instruction, null);
    }

    public static <T extends Throwable> void testThrowsAny(Class<T> expectedThrowable, Instruction instruction, Validator<T> throwableValidator) {
        boolean fail;
        block3: {
            fail = false;
            try {
                instruction.execute();
                fail = true;
            }
            catch (Throwable e) {
                ThrowableTester.assertAnyThrowableType(expectedThrowable, e);
                if (throwableValidator == null) break block3;
                Throwable throwable = e;
                throwableValidator.assertThrowable(throwable);
            }
        }
        if (fail) {
            Assert.fail((String)("Expected any <" + expectedThrowable.getName() + "> but nothing was thrown"));
        }
    }

    public static <T extends Throwable> void testThrows(Class<T> expectedThrowable, Instruction instruction) {
        ThrowableTester.testThrows(expectedThrowable, instruction, null);
    }

    public static <T extends Throwable> void testThrows(Class<T> expectedThrowable, Instruction instruction, Validator<T> throwableValidator) {
        boolean fail;
        block3: {
            fail = false;
            try {
                instruction.execute();
                fail = true;
            }
            catch (Throwable e) {
                ThrowableTester.assertThrowableType(expectedThrowable, e);
                if (throwableValidator == null) break block3;
                Throwable throwable = e;
                throwableValidator.assertThrowable(throwable);
            }
        }
        if (fail) {
            Assert.fail((String)("Expected <" + expectedThrowable.getName() + "> but nothing was thrown"));
        }
    }

    public static interface Validator<E extends Throwable> {
        public void assertThrowable(E var1);
    }

    public static interface Instruction {
        public void execute() throws Throwable;
    }
}

