/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.persistence.util.test;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;

public final class SerializabilityTester {
    private SerializabilityTester() {
    }

    public static <T extends Serializable> void testSerialization(T serializable, SemanticCompatibilityVerifier<T> semanticCompatibilityVerifier) {
        byte[] serialization = null;
        try (ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
             ObjectOutputStream objectOutputStream = new ObjectOutputStream(byteArrayOutputStream);){
            objectOutputStream.writeObject(serializable);
            serialization = byteArrayOutputStream.toByteArray();
        }
        catch (Exception e) {
            throw new RuntimeException("Serialization failure: " + e.getMessage(), e);
        }
        Object replicaObj = null;
        try (ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(serialization);
             ObjectInputStream objectInputStream = new ObjectInputStream(byteArrayInputStream);){
            replicaObj = objectInputStream.readObject();
        }
        catch (Exception e) {
            throw new RuntimeException("Deserialization failure: " + e.getMessage(), e);
        }
        if (semanticCompatibilityVerifier != null) {
            Serializable replica = (Serializable)replicaObj;
            semanticCompatibilityVerifier.assertSemanticCompatibility(serializable, replica);
        }
    }

    public static interface SemanticCompatibilityVerifier<T extends Serializable> {
        public void assertSemanticCompatibility(T var1, T var2);
    }
}

