/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.persistence.util.common.type;

import com.google.common.base.Objects;
import java.io.Serializable;

public final class Date
implements Serializable,
Comparable<Date> {
    private static final long serialVersionUID = 1L;
    private final long value;

    private Date(long date) {
        this.value = date;
    }

    public static Date valueOf(long date) {
        return new Date(date);
    }

    public static Date valueOf(java.util.Date date) {
        if (date == null) {
            return null;
        }
        return new Date(date.getTime());
    }

    public static Date currentTime() {
        return new Date(System.currentTimeMillis());
    }

    public long getTime() {
        return this.value;
    }

    public java.util.Date toDate() {
        return new java.util.Date(this.value);
    }

    @Override
    public int compareTo(Date o) {
        return Long.compare(this.value, o.value);
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (int)(this.value ^ this.value >>> 32);
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Date)) {
            return false;
        }
        Date other = (Date)obj;
        return this.value == other.value;
    }

    public String toString() {
        return Objects.toStringHelper(this.getClass()).add("value", (Object)this.toDate()).toString();
    }
}

