/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.persistence.util.common.io;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.FileSystems;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.InvalidPathException;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.BasicFileAttributes;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Arrays;
import org.opendaylight.persistence.util.common.io.IoUtil;

public class FileUtil {
    private FileUtil() {
    }

    public static InputStream loadResource(Path path) {
        return FileUtil.loadResource(path, Thread.currentThread().getContextClassLoader());
    }

    public static InputStream loadResource(Path path, ClassLoader classLoader) {
        if (path == null) {
            throw new NullPointerException("path cannot be null");
        }
        if (classLoader == null) {
            throw new NullPointerException("classLoader cannot be null");
        }
        return classLoader.getResourceAsStream(path.toFile().getPath());
    }

    public static InputStream open(Path path) throws IOException {
        if (Files.exists(path, new LinkOption[0])) {
            return Files.newInputStream(path, new OpenOption[0]);
        }
        return FileUtil.loadResource(path);
    }

    public static byte[] readAllBytes(Path path) throws IOException, FileNotFoundException {
        if (path == null) {
            throw new NullPointerException("path cannot be null");
        }
        if (Files.exists(path, new LinkOption[0])) {
            return Files.readAllBytes(path);
        }
        try (InputStream input = FileUtil.loadResource(path);){
            if (input != null) {
                byte[] byArray = IoUtil.read(input);
                return byArray;
            }
        }
        throw new FileNotFoundException("File not found: " + path);
    }

    public static Path getPath(String first, String ... more) {
        return FileSystems.getDefault().getPath(first, more);
    }

    public static Path getPath(Path parent, String first, String ... more) throws InvalidPathException {
        ArrayList<String> components = new ArrayList<String>();
        components.add(first);
        if (more != null) {
            components.addAll(Arrays.asList(more));
        }
        return FileSystems.getDefault().getPath(parent.toFile().getPath(), components.toArray(new String[0]));
    }

    public static Path getPath(Path parent, Path first, Path ... more) throws InvalidPathException {
        ArrayList<String> components = new ArrayList<String>();
        components.add(first.toFile().getPath());
        if (more != null) {
            for (Path path : more) {
                components.add(path.toFile().getPath());
            }
        }
        return FileSystems.getDefault().getPath(parent.toFile().getPath(), components.toArray(new String[0]));
    }

    public static Path getTempDirectory() {
        return FileSystems.getDefault().getPath(System.getProperty("java.io.tmpdir"), new String[0]);
    }

    public static Path translate(Path descendant, Path ancestor, Path translatedAncestor) {
        if (descendant == null) {
            throw new NullPointerException("descendant cannot be null");
        }
        if (ancestor == null) {
            throw new NullPointerException("ancestor cannot be null");
        }
        if (translatedAncestor == null) {
            throw new NullPointerException("translatedAncestor cannot be null");
        }
        if (!descendant.startsWith(ancestor)) {
            throw new IllegalArgumentException(ancestor + " is not an ancestor of " + descendant);
        }
        return translatedAncestor.resolve(ancestor.relativize(descendant));
    }

    public static void deleteRecursively(Path path) throws IOException {
        if (!Files.exists(path, new LinkOption[0])) {
            return;
        }
        Files.walkFileTree(path, (FileVisitor<? super Path>)new FileVisitor<Path>(){

            @Override
            public FileVisitResult preVisitDirectory(Path dir, BasicFileAttributes attrs) throws IOException {
                return FileVisitResult.CONTINUE;
            }

            @Override
            public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) throws IOException {
                Files.delete(file);
                return FileVisitResult.CONTINUE;
            }

            @Override
            public FileVisitResult visitFileFailed(Path file, IOException error) throws IOException {
                Files.delete(file);
                return FileVisitResult.CONTINUE;
            }

            @Override
            public FileVisitResult postVisitDirectory(Path dir, IOException error) throws IOException {
                if (error == null) {
                    Files.delete(dir);
                    return FileVisitResult.CONTINUE;
                }
                throw error;
            }
        });
    }

    public static void copyRecursively(final Path source, final Path target, final StandardCopyOption copyOption) throws IllegalArgumentException, IOException {
        if (!Files.exists(source, new LinkOption[0])) {
            throw new IllegalArgumentException(source + " does not exist");
        }
        Files.walkFileTree(source, (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

            @Override
            public FileVisitResult preVisitDirectory(Path dir, BasicFileAttributes attrs) throws IOException {
                Path targetPath = FileUtil.translate(dir, source, target);
                if (!Files.exists(targetPath, new LinkOption[0])) {
                    Files.createDirectory(targetPath, new FileAttribute[0]);
                }
                return FileVisitResult.CONTINUE;
            }

            @Override
            public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) throws IOException {
                Path targetPath = FileUtil.translate(file, source, target);
                Files.copy(file, targetPath, copyOption);
                return FileVisitResult.CONTINUE;
            }
        });
    }
}

