/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.persistence.util.common.filter;

import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableSet;
import java.io.Serializable;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import org.opendaylight.persistence.util.common.Converter;

public final class SetCondition<D>
implements Serializable {
    private static final long serialVersionUID = 1L;
    private final Set<D> values;
    private final Mode mode;

    private SetCondition(Set<D> values, Mode mode) {
        this.values = ImmutableSet.copyOf((Collection)((Collection)Preconditions.checkNotNull(values, (Object)"values")));
        this.mode = mode;
    }

    public static <D> SetCondition<D> in(Set<D> values) {
        return new SetCondition<D>(values, Mode.IN);
    }

    @SafeVarargs
    public static <D> SetCondition<D> in(D ... values) {
        return SetCondition.in(ImmutableSet.copyOf((Object[])values));
    }

    public static <D> SetCondition<D> notIn(Set<D> values) {
        return new SetCondition<D>(values, Mode.NOT_IN);
    }

    @SafeVarargs
    public static <D> SetCondition<D> notIn(D ... values) {
        return SetCondition.notIn(ImmutableSet.copyOf((Object[])values));
    }

    public Set<D> getValues() {
        return this.values;
    }

    public Mode getMode() {
        return this.mode;
    }

    public <T> SetCondition<T> convert(Converter<D, T> converter) {
        Preconditions.checkNotNull(converter, (Object)"converter");
        HashSet<T> convertedValues = new HashSet<T>();
        for (D value : this.values) {
            convertedValues.add(converter.convert(value));
        }
        return new SetCondition(convertedValues, this.mode);
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("values", this.values).add("mode", (Object)this.mode).toString();
    }

    public static enum Mode {
        IN,
        NOT_IN;

    }
}

