/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.persistence.util.common.filter;

import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import java.io.Serializable;
import org.opendaylight.persistence.util.common.Converter;
import org.opendaylight.persistence.util.common.type.Interval;

public final class IntervalCondition<D extends Comparable<D>>
implements Serializable {
    private static final long serialVersionUID = 1L;
    private final Interval<D> value;
    private final Mode mode;

    private IntervalCondition(Interval<D> value, Mode mode) {
        this.value = (Interval)Preconditions.checkNotNull(value, (Object)"value");
        this.mode = (Mode)((Object)Preconditions.checkNotNull((Object)((Object)mode), (Object)"mode"));
    }

    public static <D extends Comparable<D>> IntervalCondition<D> in(Interval<D> value) {
        return new IntervalCondition<D>(value, Mode.IN);
    }

    public static <D extends Comparable<D>> IntervalCondition<D> notIn(Interval<D> value) {
        return new IntervalCondition<D>(value, Mode.NOT_IN);
    }

    public Interval<D> getValue() {
        return this.value;
    }

    public Mode getMode() {
        return this.mode;
    }

    public <T extends Comparable<T>> IntervalCondition<T> convert(Converter<D, T> converter) throws NullPointerException {
        Preconditions.checkNotNull(converter, (Object)"converter");
        return new IntervalCondition<T>(this.value.convert(converter), this.mode);
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("value", this.value).add("mode", (Object)this.mode).toString();
    }

    public static enum Mode {
        IN,
        NOT_IN;

    }
}

