/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.persistence.util.common.type.page;

import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import java.io.Serializable;
import java.util.Arrays;
import java.util.List;
import javax.annotation.Nonnull;
import org.opendaylight.persistence.util.common.type.page.PageRequest;

public class Page<R extends PageRequest, D>
implements Serializable {
    private static final long serialVersionUID = 1L;
    private final R request;
    private final List<D> data;

    public Page(@Nonnull R pageRequest, @Nonnull List<D> data) {
        this.request = (PageRequest)Preconditions.checkNotNull(pageRequest, (Object)"pageRequest cannot be null");
        Preconditions.checkNotNull(data, (Object)"data cannot be null");
        this.data = ImmutableList.copyOf(data);
    }

    @SafeVarargs
    public Page(R pageRequest, D ... data) {
        this(pageRequest, Arrays.asList(data));
    }

    public List<D> getData() {
        return this.data;
    }

    public R getRequest() {
        return this.request;
    }

    public boolean isEmpty() {
        return this.data.size() <= 0;
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("request", this.request).add("data", this.data).toString();
    }
}

