/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.persistence.util.common.type.page;

import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.opendaylight.persistence.util.common.Converter;
import org.opendaylight.persistence.util.common.type.page.OffsetPageRequest;
import org.opendaylight.persistence.util.common.type.page.Page;

public class OffsetPage<D>
extends Page<OffsetPageRequest, D> {
    private static final long serialVersionUID = 1L;
    private static final OffsetPage EMPTY_PAGE = new OffsetPage(new OffsetPageRequest(0L, 1), Collections.emptyList(), 0L);
    private final long totalRecordCount;

    public OffsetPage(OffsetPageRequest pageRequest, List<D> data, long totalRecordCount) {
        super(pageRequest, data);
        Preconditions.checkArgument((totalRecordCount >= 0L ? 1 : 0) != 0, (Object)"totalRecordCount must be greater or equals to zero");
        this.totalRecordCount = totalRecordCount;
    }

    public static final <T> OffsetPage<T> emptyPage() {
        return EMPTY_PAGE;
    }

    public long getTotalRecordCount() {
        return this.totalRecordCount;
    }

    public int getTotalPageCount() {
        long pageCount = 0L;
        if (this.totalRecordCount > 0L) {
            long recordsUpToThisPage = this.totalRecordCount;
            if (this.totalRecordCount >= ((OffsetPageRequest)this.getRequest()).getOffset()) {
                recordsUpToThisPage = ((OffsetPageRequest)this.getRequest()).getOffset() + (long)this.getData().size();
            }
            long recordsAfterThisPage = this.totalRecordCount - recordsUpToThisPage;
            long pagesUpToThisPage = 0L;
            if (recordsUpToThisPage > 0L) {
                if (recordsUpToThisPage >= ((OffsetPageRequest)this.getRequest()).getOffset()) {
                    pagesUpToThisPage = ((OffsetPageRequest)this.getRequest()).getPageIndex() + 1;
                } else {
                    pagesUpToThisPage = recordsUpToThisPage / (long)((OffsetPageRequest)this.getRequest()).getSize();
                    if (recordsUpToThisPage % (long)((OffsetPageRequest)this.getRequest()).getSize() != 0L) {
                        ++pagesUpToThisPage;
                    }
                }
            }
            long pagesAfterThisPage = 0L;
            if (recordsAfterThisPage > 0L) {
                pagesAfterThisPage = recordsAfterThisPage / (long)((OffsetPageRequest)this.getRequest()).getSize();
                if (recordsAfterThisPage % (long)((OffsetPageRequest)this.getRequest()).getSize() != 0L) {
                    ++pagesAfterThisPage;
                }
            }
            pageCount = pagesUpToThisPage + pagesAfterThisPage;
        }
        return (int)pageCount;
    }

    public <T> OffsetPage<T> convert(Converter<D, T> converter) {
        ArrayList<T> targetItems = new ArrayList<T>(this.getData().size());
        for (Object item : this.getData()) {
            targetItems.add(converter.convert(item));
        }
        return new OffsetPage((OffsetPageRequest)this.getRequest(), targetItems, this.totalRecordCount);
    }

    public boolean hasNext() {
        return ((OffsetPageRequest)this.getRequest()).getPageIndex() < this.getTotalPageCount() - 1;
    }

    public boolean hasPrevious() {
        return ((OffsetPageRequest)this.getRequest()).getPageIndex() > 0;
    }

    public OffsetPageRequest getNextPageRequest() {
        OffsetPageRequest request = null;
        if (this.hasNext()) {
            request = new OffsetPageRequest(((OffsetPageRequest)this.getRequest()).getOffset() + (long)this.getData().size(), ((OffsetPageRequest)this.getRequest()).getSize());
        }
        return request;
    }

    public OffsetPageRequest getPreviousPageRequest() {
        OffsetPageRequest request = null;
        if (this.hasPrevious()) {
            long offset = ((OffsetPageRequest)this.getRequest()).getOffset() - (long)((OffsetPageRequest)this.getRequest()).getSize();
            request = new OffsetPageRequest(offset >= 0L ? offset : 0L, ((OffsetPageRequest)this.getRequest()).getSize());
        }
        return request;
    }

    @Override
    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("pageRequest", this.getRequest()).add("totalRecordCount", this.totalRecordCount).add("data", this.getData()).toString();
    }
}

