/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.persistence.util.common.type.page;

import com.google.common.base.MoreObjects;
import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import javax.annotation.Nonnull;
import org.opendaylight.persistence.util.common.type.page.PageRequest;

public class MarkPageRequest<M>
extends PageRequest {
    private static final long serialVersionUID = 1L;
    private final M mark;
    private final Navigation navigation;

    public MarkPageRequest(int size) {
        this(null, Navigation.NEXT, size);
    }

    public MarkPageRequest(M mark, @Nonnull Navigation navigation, int size) {
        super(size);
        this.navigation = (Navigation)((Object)Preconditions.checkNotNull((Object)((Object)navigation)));
        this.mark = mark;
    }

    public M getMark() {
        return this.mark;
    }

    public Navigation getNavigation() {
        return this.navigation;
    }

    public <T> MarkPageRequest<T> convert(T convertedMark) {
        return new MarkPageRequest<T>(convertedMark, this.navigation, this.getSize());
    }

    @Override
    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.mark, this.navigation});
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        MarkPageRequest other = (MarkPageRequest)obj;
        if (!Objects.equal(this.mark, other.mark)) {
            return false;
        }
        if (this.navigation != other.navigation) {
            return false;
        }
        return this.getSize() == other.getSize();
    }

    @Override
    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("mark", this.mark).add("navigation", (Object)this.navigation).add("size", this.getSize()).toString();
    }

    public static enum Navigation {
        NEXT,
        PREVIOUS;

    }
}

