/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.persistence.util.common.type.page;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.opendaylight.persistence.util.common.Converter;
import org.opendaylight.persistence.util.common.type.page.MarkPageRequest;
import org.opendaylight.persistence.util.common.type.page.Page;

public class MarkPage<D>
extends Page<MarkPageRequest<D>, D> {
    private static final long serialVersionUID = 1L;
    private static final MarkPage EMPTY_PAGE = new MarkPage(new MarkPageRequest(1), Collections.emptyList());

    public MarkPage(MarkPageRequest<D> pageRequest, List<D> data) {
        super(pageRequest, data);
    }

    public static final <T> MarkPage<T> emptyPage() {
        return EMPTY_PAGE;
    }

    public <T> MarkPage<T> convert(Converter<D, T> converter) {
        ArrayList<T> targetItems = new ArrayList<T>(this.getData().size());
        for (Object item : this.getData()) {
            targetItems.add(converter.convert(item));
        }
        Object targetMark = ((MarkPageRequest)this.getRequest()).getMark() != null ? (Object)converter.convert(((MarkPageRequest)this.getRequest()).getMark()) : null;
        MarkPageRequest<Object> targetRequest = new MarkPageRequest<Object>(targetMark, ((MarkPageRequest)this.getRequest()).getNavigation(), ((MarkPageRequest)this.getRequest()).getSize());
        return new MarkPage<Object>(targetRequest, (List<Object>)targetItems);
    }

    public MarkPageRequest<D> getNextPageRequest() {
        MarkPageRequest request = null;
        if (!this.isEmpty()) {
            request = new MarkPageRequest(this.getData().get(this.getData().size() - 1), MarkPageRequest.Navigation.NEXT, ((MarkPageRequest)this.getRequest()).getSize());
        }
        return request;
    }

    public MarkPageRequest<D> getPreviousPageRequest() {
        MarkPageRequest request = null;
        if (!this.isEmpty()) {
            request = new MarkPageRequest(this.getData().get(0), MarkPageRequest.Navigation.PREVIOUS, ((MarkPageRequest)this.getRequest()).getSize());
        }
        return request;
    }
}

