/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.persistence.util.common.type;

import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import java.io.Serializable;

public abstract class SerializableValueType<E extends Serializable>
implements Serializable {
    private static final long serialVersionUID = 1L;
    private final E value;

    protected SerializableValueType(E value) {
        this.value = (Serializable)Preconditions.checkNotNull(value, (Object)"value cannot be null");
    }

    public E getValue() {
        return this.value;
    }

    public int hashCode() {
        return this.value.hashCode();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        SerializableValueType other = (SerializableValueType)obj;
        return this.value.equals(other.value);
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("value", this.value).toString();
    }

    public static <E extends Serializable> E toValue(SerializableValueType<E> valueType) {
        if (valueType == null) {
            return null;
        }
        return valueType.getValue();
    }
}

