/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.persistence.util.common.type;

import com.google.common.base.MoreObjects;
import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import java.io.Serializable;
import org.opendaylight.persistence.util.common.Container;
import org.opendaylight.persistence.util.common.Converter;

public final class Interval<C extends Comparable<C>>
implements Container<C>,
Serializable {
    private static final long serialVersionUID = 1L;
    private final C leftEndpoint;
    private final C rightEndpoint;
    private final Type type;

    public static <T extends Comparable<T>> Interval<T> open(T leftEndpoint, T rightEndpoint) {
        return new Interval<T>(leftEndpoint, rightEndpoint, Type.OPEN);
    }

    public static <T extends Comparable<T>> Interval<T> closed(T leftEndpoint, T rightEndpoint) {
        return new Interval<T>(leftEndpoint, rightEndpoint, Type.CLOSED);
    }

    public static <T extends Comparable<T>> Interval<T> leftOpenRightClosed(T leftEndpoint, T rightEndpoint) {
        return new Interval<T>(leftEndpoint, rightEndpoint, Type.LEFT_OPEN_RIGHT_CLOSED);
    }

    public static <T extends Comparable<T>> Interval<T> leftClosedRightOpen(T leftEndpoint, T rightEndpoint) {
        return new Interval<T>(leftEndpoint, rightEndpoint, Type.LEFT_CLOSED_RIGHT_OPEN);
    }

    public static <T extends Comparable<T>> Interval<T> leftOpenRightUnbounded(T leftEndpoint) {
        return new Interval<Object>(leftEndpoint, null, Type.LEFT_OPEN_RIGHT_UNBOUNDED);
    }

    public static <T extends Comparable<T>> Interval<T> leftClosedRightUnbounded(T leftEndpoint) {
        return new Interval<Object>(leftEndpoint, null, Type.LEFT_CLOSED_RIGHT_UNBOUNDED);
    }

    public static <T extends Comparable<T>> Interval<T> leftUnboundedRightOpen(T rightEndpoint) {
        return new Interval<Object>(null, rightEndpoint, Type.LEFT_UNBOUNDED_RIGHT_OPEN);
    }

    public static <T extends Comparable<T>> Interval<T> leftUnboundedRightClosed(T rightEndpoint) {
        return new Interval<Object>(null, rightEndpoint, Type.LEFT_UNBOUNDED_RIGHT_CLOSED);
    }

    public static <T extends Comparable<T>> Interval<T> unbounded() {
        return new Interval<Object>(null, null, Type.UNBOUNDED);
    }

    public static <T extends Comparable<T>> Interval<T> createOpen(T leftEndpoint, T rightEndpoint) {
        Interval<T> interval = null;
        interval = leftEndpoint == null ? (rightEndpoint == null ? Interval.unbounded() : Interval.leftUnboundedRightOpen(rightEndpoint)) : (rightEndpoint == null ? Interval.leftOpenRightUnbounded(leftEndpoint) : Interval.open(leftEndpoint, rightEndpoint));
        return interval;
    }

    public static <T extends Comparable<T>> Interval<T> createClosed(T leftEndpoint, T rightEndpoint) {
        Interval<T> interval = null;
        interval = leftEndpoint == null ? (rightEndpoint == null ? Interval.unbounded() : Interval.leftUnboundedRightClosed(rightEndpoint)) : (rightEndpoint == null ? Interval.leftClosedRightUnbounded(leftEndpoint) : Interval.closed(leftEndpoint, rightEndpoint));
        return interval;
    }

    Interval(C leftEndpoint, C rightEndpoint, Type type) throws NullPointerException {
        Preconditions.checkNotNull((Object)((Object)type), (Object)"type");
        type.validate(leftEndpoint, rightEndpoint);
        this.type = type;
        this.leftEndpoint = leftEndpoint;
        this.rightEndpoint = rightEndpoint;
    }

    public C getLeftEndpoint() {
        return this.isLeftUnbounded() ? null : (C)this.leftEndpoint;
    }

    public C getRightEndpoint() {
        return this.isRigthUnbounded() ? null : (C)this.rightEndpoint;
    }

    public Type getType() {
        return this.type;
    }

    @Override
    public boolean contains(C element) {
        return element != null && this.type.contains(element, this.leftEndpoint, this.rightEndpoint);
    }

    public boolean isEmpty() {
        return !this.isLeftUnbounded() && !this.isRigthUnbounded() && this.leftEndpoint.compareTo(this.rightEndpoint) == 0;
    }

    private boolean isLeftUnbounded() {
        return this.type == Type.UNBOUNDED || this.type == Type.LEFT_UNBOUNDED_RIGHT_OPEN || this.type == Type.LEFT_UNBOUNDED_RIGHT_CLOSED;
    }

    private boolean isRigthUnbounded() {
        return this.type == Type.UNBOUNDED || this.type == Type.LEFT_OPEN_RIGHT_UNBOUNDED || this.type == Type.LEFT_CLOSED_RIGHT_UNBOUNDED;
    }

    public <T extends Comparable<T>> Interval<T> convert(Converter<C, T> converter) {
        Preconditions.checkNotNull(converter, (Object)"converter");
        return new Interval<Comparable>((Comparable)converter.convert(this.leftEndpoint), (Comparable)converter.convert(this.rightEndpoint), this.type);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof Interval)) {
            return false;
        }
        Interval other = (Interval)obj;
        if (this.type != other.type) {
            return false;
        }
        if (this.leftEndpoint == null ? other.leftEndpoint != null : !this.leftEndpoint.equals(other.leftEndpoint)) {
            return false;
        }
        return !(this.rightEndpoint == null ? other.rightEndpoint != null : !this.rightEndpoint.equals(other.rightEndpoint));
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.type, this.leftEndpoint, this.rightEndpoint});
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("leftEndpoint", this.leftEndpoint).add("rightEndpoint", this.rightEndpoint).add("type", (Object)this.type).toString();
    }

    public static enum Type {
        OPEN{

            @Override
            <C extends Comparable<C>> void validate(C leftEndpoint, C rightEndpoint) {
                Preconditions.checkArgument((leftEndpoint != null ? 1 : 0) != 0, (Object)"leftEndpoint cannot be null");
                Preconditions.checkArgument((rightEndpoint != null ? 1 : 0) != 0, (Object)"rightEndpoint cannot be null");
                Preconditions.checkArgument((leftEndpoint.compareTo(rightEndpoint) <= 0 ? 1 : 0) != 0, (Object)"leftEndpoint cannot be greater than rightEndpoint");
            }

            @Override
            <C extends Comparable<C>> boolean contains(C element, C leftEndpoint, C rightEndpoint) {
                return element.compareTo(leftEndpoint) > 0 && element.compareTo(rightEndpoint) < 0;
            }
        }
        ,
        CLOSED{

            @Override
            <C extends Comparable<C>> void validate(C leftEndpoint, C rightEndpoint) {
                Preconditions.checkArgument((leftEndpoint != null ? 1 : 0) != 0, (Object)"leftEndpoint cannot be null");
                Preconditions.checkArgument((rightEndpoint != null ? 1 : 0) != 0, (Object)"rightEndpoint cannot be null");
                Preconditions.checkArgument((leftEndpoint.compareTo(rightEndpoint) <= 0 ? 1 : 0) != 0, (Object)"leftEndpoint cannot be greater than rightEndpoint");
            }

            @Override
            <C extends Comparable<C>> boolean contains(C element, C leftEndpoint, C rightEndpoint) {
                return element.compareTo(leftEndpoint) >= 0 && element.compareTo(rightEndpoint) <= 0;
            }
        }
        ,
        UNBOUNDED{

            @Override
            <C extends Comparable<C>> void validate(C leftEndpoint, C rightEndpoint) {
            }

            @Override
            <C extends Comparable<C>> boolean contains(C element, C leftEndpoint, C rightEndpoint) {
                return true;
            }
        }
        ,
        LEFT_CLOSED_RIGHT_OPEN{

            @Override
            <C extends Comparable<C>> void validate(C leftEndpoint, C rightEndpoint) {
                Preconditions.checkArgument((leftEndpoint != null ? 1 : 0) != 0, (Object)"leftEndpoint cannot be null");
                Preconditions.checkArgument((rightEndpoint != null ? 1 : 0) != 0, (Object)"rightEndpoint cannot be null");
                Preconditions.checkArgument((leftEndpoint.compareTo(rightEndpoint) <= 0 ? 1 : 0) != 0, (Object)"leftEndpoint cannot be greater than rightEndpoint");
            }

            @Override
            <C extends Comparable<C>> boolean contains(C element, C leftEndpoint, C rightEndpoint) {
                return element.compareTo(leftEndpoint) >= 0 && element.compareTo(rightEndpoint) < 0;
            }
        }
        ,
        LEFT_OPEN_RIGHT_CLOSED{

            @Override
            <C extends Comparable<C>> void validate(C leftEndpoint, C rightEndpoint) {
                Preconditions.checkArgument((leftEndpoint != null ? 1 : 0) != 0, (Object)"leftEndpoint cannot be null");
                Preconditions.checkArgument((rightEndpoint != null ? 1 : 0) != 0, (Object)"rightEndpoint cannot be null");
                Preconditions.checkArgument((leftEndpoint.compareTo(rightEndpoint) <= 0 ? 1 : 0) != 0, (Object)"leftEndpoint cannot be greater than rightEndpoint");
            }

            @Override
            <C extends Comparable<C>> boolean contains(C element, C leftEndpoint, C rightEndpoint) {
                return element.compareTo(leftEndpoint) > 0 && element.compareTo(rightEndpoint) <= 0;
            }
        }
        ,
        LEFT_OPEN_RIGHT_UNBOUNDED{

            @Override
            <C extends Comparable<C>> void validate(C leftEndpoint, C rightEndpoint) {
                Preconditions.checkArgument((leftEndpoint != null ? 1 : 0) != 0, (Object)"leftEndpoint cannot be null");
            }

            @Override
            <C extends Comparable<C>> boolean contains(C element, C leftEndpoint, C rightEndpoint) {
                return element.compareTo(leftEndpoint) > 0;
            }
        }
        ,
        LEFT_CLOSED_RIGHT_UNBOUNDED{

            @Override
            <C extends Comparable<C>> void validate(C leftEndpoint, C rightEndpoint) {
                Preconditions.checkArgument((leftEndpoint != null ? 1 : 0) != 0, (Object)"leftEndpoint cannot be null");
            }

            @Override
            <C extends Comparable<C>> boolean contains(C element, C leftEndpoint, C rightEndpoint) {
                return element.compareTo(leftEndpoint) >= 0;
            }
        }
        ,
        LEFT_UNBOUNDED_RIGHT_OPEN{

            @Override
            <C extends Comparable<C>> void validate(C leftEndpoint, C rightEndpoint) {
                Preconditions.checkArgument((rightEndpoint != null ? 1 : 0) != 0, (Object)"rightEndpoint cannot be null");
            }

            @Override
            <C extends Comparable<C>> boolean contains(C element, C leftEndpoint, C rightEndpoint) {
                return element.compareTo(rightEndpoint) < 0;
            }
        }
        ,
        LEFT_UNBOUNDED_RIGHT_CLOSED{

            @Override
            <C extends Comparable<C>> void validate(C leftEndpoint, C rightEndpoint) {
                Preconditions.checkArgument((rightEndpoint != null ? 1 : 0) != 0, (Object)"rightEndpoint cannot be null");
            }

            @Override
            <C extends Comparable<C>> boolean contains(C element, C leftEndpoint, C rightEndpoint) {
                return element.compareTo(rightEndpoint) <= 0;
            }
        };


        abstract <C extends Comparable<C>> void validate(C var1, C var2);

        abstract <C extends Comparable<C>> boolean contains(C var1, C var2, C var3);
    }
}

