/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.persistence.util.common.io;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

public class IoUtil {
    private static final int BUFFER_SIZE = 1024;

    private IoUtil() {
    }

    public static byte[] read(InputStream input) throws IOException {
        return IoUtil.read(input, new byte[1024]);
    }

    public static byte[] read(InputStream input, byte[] buffer) throws IOException {
        if (buffer == null) {
            throw new NullPointerException("buffer cannot be null");
        }
        try (ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();){
            int bytesRead;
            while ((bytesRead = input.read(buffer)) > 0) {
                byteArrayOutputStream.write(buffer, 0, bytesRead);
            }
            byte[] byArray = byteArrayOutputStream.toByteArray();
            return byArray;
        }
    }

    public static byte[] read(InputStream input, int length) throws IOException {
        return IoUtil.read(input, length, new byte[1024]);
    }

    public static byte[] read(InputStream input, int length, byte[] buffer) throws IOException {
        if (buffer == null) {
            throw new NullPointerException("buffer cannot be null");
        }
        try (ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();){
            int bytesRead;
            long totalBytes = 0L;
            int bytesToRead = Math.min(buffer.length, length);
            while (bytesToRead > 0 && (bytesRead = input.read(buffer, 0, bytesToRead)) > 0) {
                byteArrayOutputStream.write(buffer, 0, bytesRead);
                bytesToRead = (int)Math.min((long)buffer.length, (long)length - (totalBytes += (long)bytesRead));
            }
            byte[] byArray = byteArrayOutputStream.toByteArray();
            return byArray;
        }
    }

    public static long copy(InputStream input, OutputStream output) throws IOException {
        return IoUtil.copy(input, output, new byte[1024]);
    }

    public static long copy(InputStream input, OutputStream output, byte[] buffer) throws IOException {
        int bytesRead;
        if (buffer == null) {
            throw new NullPointerException("buffer cannot be null");
        }
        long totalBytes = 0L;
        while ((bytesRead = input.read(buffer)) > 0) {
            output.write(buffer, 0, bytesRead);
            totalBytes += (long)bytesRead;
        }
        return totalBytes;
    }

    public static long copy(InputStream input, OutputStream output, long length) throws IOException {
        return IoUtil.copy(input, output, length, new byte[1024]);
    }

    public static long copy(InputStream input, OutputStream output, long length, byte[] buffer) throws IOException {
        int bytesRead;
        if (buffer == null) {
            throw new NullPointerException("buffer cannot be null");
        }
        long totalBytes = 0L;
        int bytesToRead = (int)Math.min((long)buffer.length, length);
        while (bytesToRead > 0 && (bytesRead = input.read(buffer, 0, bytesToRead)) > 0) {
            output.write(buffer, 0, bytesRead);
            bytesToRead = (int)Math.min((long)buffer.length, length - (totalBytes += (long)bytesRead));
        }
        return totalBytes;
    }
}

