/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.persistence.util.common.converter;

import com.google.common.base.Preconditions;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import javax.annotation.Nonnull;
import org.opendaylight.persistence.util.common.Converter;
import org.opendaylight.persistence.util.common.ParameterizedFactory;

public final class CollectionConverter {
    private CollectionConverter() {
    }

    public static <S, T, C extends Collection<T>> C convert(@Nonnull Collection<S> source, Converter<S, T> converter, @Nonnull ParameterizedFactory<C, Integer> factory) {
        Preconditions.checkNotNull(converter, (Object)"converter");
        Preconditions.checkNotNull(factory, (Object)"factory");
        int capacity = source != null ? source.size() : 0;
        Collection target = (Collection)factory.create(capacity);
        if (source != null) {
            for (S s : source) {
                target.add(converter.convert(s));
            }
        }
        return (C)target;
    }

    public static <T> ParameterizedFactory<List<T>, Integer> getArrayListFactory() {
        return ArrayListFactory.getInstance();
    }

    public static <T> ParameterizedFactory<List<T>, Integer> getLinkedListFactory() {
        return LinkedListFactory.getInstance();
    }

    public static <T> ParameterizedFactory<Set<T>, Integer> getHashSetFactory() {
        return HashSetFactory.getInstance();
    }

    public static <T> ParameterizedFactory<Set<T>, Integer> getTreeSetFactory() {
        return TreeSetFactory.getInstance();
    }

    private static class TreeSetFactory<T>
    implements ParameterizedFactory<Set<T>, Integer> {
        private static final ParameterizedFactory INSTANCE = new TreeSetFactory();

        private TreeSetFactory() {
        }

        public static <T> ParameterizedFactory<Set<T>, Integer> getInstance() {
            return INSTANCE;
        }

        @Override
        public Set<T> create(Integer capacity) {
            if (capacity == 0) {
                return Collections.emptySet();
            }
            return new TreeSet();
        }
    }

    private static class HashSetFactory<T>
    implements ParameterizedFactory<Set<T>, Integer> {
        private static final ParameterizedFactory INSTANCE = new HashSetFactory();

        private HashSetFactory() {
        }

        public static <T> ParameterizedFactory<Set<T>, Integer> getInstance() {
            return INSTANCE;
        }

        @Override
        public Set<T> create(Integer capacity) {
            if (capacity == 0) {
                return Collections.emptySet();
            }
            return new HashSet(capacity);
        }
    }

    private static class LinkedListFactory<T>
    implements ParameterizedFactory<List<T>, Integer> {
        private static final ParameterizedFactory INSTANCE = new LinkedListFactory();

        private LinkedListFactory() {
        }

        public static <T> ParameterizedFactory<List<T>, Integer> getInstance() {
            return INSTANCE;
        }

        @Override
        public List<T> create(Integer capacity) {
            if (capacity == 0) {
                return Collections.emptyList();
            }
            return new LinkedList();
        }
    }

    private static class ArrayListFactory<T>
    implements ParameterizedFactory<List<T>, Integer> {
        private static final ParameterizedFactory INSTANCE = new ArrayListFactory();

        private ArrayListFactory() {
        }

        public static <T> ParameterizedFactory<List<T>, Integer> getInstance() {
            return INSTANCE;
        }

        @Override
        public List<T> create(Integer capacity) {
            if (capacity == 0) {
                return Collections.emptyList();
            }
            return new ArrayList(capacity);
        }
    }
}

