/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.persistence.util.common.type.page;

import com.google.common.base.MoreObjects;
import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import java.io.Serializable;

public class PageRequest
implements Serializable {
    private static final long serialVersionUID = 1L;
    private final int size;

    public PageRequest(int size) {
        Preconditions.checkArgument((size > 0 ? 1 : 0) != 0, (Object)"size must be greater than zero");
        this.size = size;
    }

    public int getSize() {
        return this.size;
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.size});
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        PageRequest other = (PageRequest)obj;
        return this.size == other.size;
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("size", this.size).toString();
    }
}

