/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.persistence.util.common.type;

import com.google.common.base.MoreObjects;
import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import java.util.TimeZone;
import javax.annotation.Nonnull;

public final class TimePeriod
implements Serializable {
    private static final long serialVersionUID = 1L;
    private final Date startTime;
    private final Date endTime;

    public TimePeriod(@Nonnull Date startTime, @Nonnull Date endTime) {
        Preconditions.checkNotNull((Object)startTime, (Object)"startTime");
        Preconditions.checkNotNull((Object)endTime, (Object)"endTime");
        Preconditions.checkArgument((startTime.compareTo(endTime) < 0 ? 1 : 0) != 0, (String)"startTime must happen before endTime: [startTime = {} endTime = {}]", (Object[])new Object[]{startTime, endTime});
        this.startTime = startTime;
        this.endTime = endTime;
    }

    public Date getStartTime() {
        return this.startTime;
    }

    public Date getEndTime() {
        return this.endTime;
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.startTime, this.endTime});
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        TimePeriod other = (TimePeriod)obj;
        if (!this.startTime.equals(other.startTime)) {
            return false;
        }
        return this.endTime.equals(other.endTime);
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("startTime", (Object)this.startTime).add("endTime", (Object)this.endTime).toString();
    }

    public static boolean isValidPeriod(Date startTime, Date endTime) {
        if (startTime == null) {
            return false;
        }
        if (endTime == null) {
            return false;
        }
        return startTime.compareTo(endTime) < 0;
    }

    public static TimePeriod getHourPeriod(Date time, TimeZone timeZone) {
        if (timeZone == null) {
            throw new NullPointerException("timezone cannot be null");
        }
        Calendar reference = Calendar.getInstance(timeZone);
        reference.setTime(time);
        Calendar startTime = Calendar.getInstance(timeZone);
        startTime.set(reference.get(1), reference.get(2), reference.get(5), reference.get(10), 0, 0);
        startTime.set(14, 0);
        Calendar endTime = Calendar.getInstance(timeZone);
        endTime.setTime(startTime.getTime());
        endTime.add(10, 1);
        endTime.add(14, -1);
        return new TimePeriod(startTime.getTime(), endTime.getTime());
    }

    public static TimePeriod getDayPeriod(Date time, TimeZone timeZone) {
        if (timeZone == null) {
            throw new NullPointerException("timezone cannot be null");
        }
        Calendar reference = Calendar.getInstance(timeZone);
        reference.setTime(time);
        Calendar startTime = Calendar.getInstance(timeZone);
        startTime.set(reference.get(1), reference.get(2), reference.get(5), 0, 0, 0);
        startTime.set(14, 0);
        Calendar endTime = Calendar.getInstance(timeZone);
        endTime.setTime(startTime.getTime());
        endTime.add(5, 1);
        endTime.add(14, -1);
        return new TimePeriod(startTime.getTime(), endTime.getTime());
    }

    public static TimePeriod getWeekPeriod(Date time, TimeZone timeZone) {
        if (timeZone == null) {
            throw new NullPointerException("timezone cannot be null");
        }
        Calendar reference = Calendar.getInstance(timeZone);
        reference.setTime(time);
        Calendar startTime = Calendar.getInstance(timeZone);
        startTime.set(reference.get(1), reference.get(2), reference.get(5), 0, 0, 0);
        startTime.set(14, 0);
        startTime.add(5, -(reference.get(7) - 1));
        Calendar endTime = Calendar.getInstance(timeZone);
        endTime.setTime(startTime.getTime());
        endTime.add(5, 7);
        endTime.add(14, -1);
        return new TimePeriod(startTime.getTime(), endTime.getTime());
    }

    public static Date[] getWeekDays(Date time, TimeZone timeZone) {
        if (timeZone == null) {
            throw new NullPointerException("timezone cannot be null");
        }
        TimePeriod weekPeriod = TimePeriod.getWeekPeriod(time, timeZone);
        Date[] week = new Date[7];
        for (int i = 0; i < week.length; ++i) {
            Calendar currentDay = Calendar.getInstance(timeZone);
            currentDay.setTime(weekPeriod.getStartTime());
            currentDay.add(5, i);
            week[i] = currentDay.getTime();
        }
        return week;
    }

    public static TimePeriod getMonthPeriod(Date time, TimeZone timeZone) {
        if (timeZone == null) {
            throw new NullPointerException("timezone cannot be null");
        }
        Calendar reference = Calendar.getInstance(timeZone);
        reference.setTime(time);
        Calendar startTime = Calendar.getInstance(timeZone);
        startTime.set(reference.get(1), reference.get(2), 1, 0, 0, 0);
        startTime.set(14, 0);
        Calendar endTime = Calendar.getInstance(timeZone);
        endTime.setTime(startTime.getTime());
        endTime.add(2, 1);
        endTime.add(14, -1);
        return new TimePeriod(startTime.getTime(), endTime.getTime());
    }

    public static TimePeriod getYearPeriod(Date time, TimeZone timeZone) {
        if (timeZone == null) {
            throw new NullPointerException("timezone cannot be null");
        }
        Calendar reference = Calendar.getInstance(timeZone);
        reference.setTime(time);
        Calendar startTime = Calendar.getInstance(timeZone);
        startTime.set(reference.get(1), 0, 1, 0, 0, 0);
        startTime.set(14, 0);
        Calendar endTime = Calendar.getInstance(timeZone);
        endTime.setTime(startTime.getTime());
        endTime.add(1, 1);
        endTime.add(14, -1);
        return new TimePeriod(startTime.getTime(), endTime.getTime());
    }

    private static List<TimePeriod> generatePeriodsFromPoints(List<Date> timePoints, TimeZone timeZone) {
        ArrayList<TimePeriod> samples = new ArrayList<TimePeriod>();
        for (int i = 0; i < timePoints.size() - 2; ++i) {
            Calendar endTime = Calendar.getInstance(timeZone);
            endTime.setTime(timePoints.get(i + 1));
            endTime.add(14, -1);
            samples.add(new TimePeriod(timePoints.get(i), endTime.getTime()));
        }
        samples.add(new TimePeriod(timePoints.get(timePoints.size() - 2), timePoints.get(timePoints.size() - 1)));
        return samples;
    }

    public List<TimePeriod> breakDownHourly(TimeZone timeZone) {
        if (timeZone == null) {
            throw new NullPointerException("timezone cannot be null");
        }
        Calendar init = Calendar.getInstance(timeZone);
        init.setTime(this.startTime);
        Calendar endCalendar = Calendar.getInstance(timeZone);
        endCalendar.setTime(this.endTime);
        Date end = endCalendar.getTime();
        ArrayList<Date> timePoints = new ArrayList<Date>();
        timePoints.add(init.getTime());
        Calendar next = Calendar.getInstance(timeZone);
        next.set(init.get(1), init.get(2), init.get(5), init.get(10), 0, 0);
        next.set(14, 0);
        next.add(10, 1);
        while (next.getTime().compareTo(end) < 0) {
            timePoints.add(next.getTime());
            next.add(10, 1);
        }
        timePoints.add(end);
        return TimePeriod.generatePeriodsFromPoints(timePoints, timeZone);
    }

    public List<TimePeriod> breakDownDaily(TimeZone timeZone) {
        if (timeZone == null) {
            throw new NullPointerException("timezone cannot be null");
        }
        Calendar init = Calendar.getInstance(timeZone);
        init.setTime(this.startTime);
        Calendar endCalendar = Calendar.getInstance(timeZone);
        endCalendar.setTime(this.endTime);
        Date end = endCalendar.getTime();
        ArrayList<Date> timePoints = new ArrayList<Date>();
        timePoints.add(init.getTime());
        Calendar next = Calendar.getInstance(timeZone);
        next.set(init.get(1), init.get(2), init.get(5), 0, 0, 0);
        next.set(14, 0);
        next.add(5, 1);
        while (next.getTime().compareTo(end) < 0) {
            timePoints.add(next.getTime());
            next.add(5, 1);
        }
        timePoints.add(end);
        return TimePeriod.generatePeriodsFromPoints(timePoints, timeZone);
    }

    public List<TimePeriod> breakDownWeekly(TimeZone timeZone) {
        if (timeZone == null) {
            throw new NullPointerException("timezone cannot be null");
        }
        Calendar init = Calendar.getInstance(timeZone);
        init.setTime(this.startTime);
        Calendar endCalendar = Calendar.getInstance(timeZone);
        endCalendar.setTime(this.endTime);
        Date end = endCalendar.getTime();
        ArrayList<Date> timePoints = new ArrayList<Date>();
        timePoints.add(init.getTime());
        Calendar next = Calendar.getInstance(timeZone);
        next.set(init.get(1), init.get(2), init.get(5), 0, 0, 0);
        next.set(14, 0);
        next.add(5, 8 - init.get(7));
        while (next.getTime().compareTo(end) < 0) {
            timePoints.add(next.getTime());
            next.add(5, 7);
        }
        timePoints.add(end);
        return TimePeriod.generatePeriodsFromPoints(timePoints, timeZone);
    }

    public List<TimePeriod> breakDownMonthly(TimeZone timeZone) {
        if (timeZone == null) {
            throw new NullPointerException("timezone cannot be null");
        }
        Calendar init = Calendar.getInstance(timeZone);
        init.setTime(this.startTime);
        Calendar endCalendar = Calendar.getInstance(timeZone);
        endCalendar.setTime(this.endTime);
        Date end = endCalendar.getTime();
        ArrayList<Date> timePoints = new ArrayList<Date>();
        timePoints.add(init.getTime());
        Calendar next = Calendar.getInstance(timeZone);
        next.set(init.get(1), init.get(2), 1, 0, 0, 0);
        next.set(14, 0);
        next.add(2, 1);
        while (next.getTime().compareTo(end) < 0) {
            timePoints.add(next.getTime());
            next.add(2, 1);
        }
        timePoints.add(end);
        return TimePeriod.generatePeriodsFromPoints(timePoints, timeZone);
    }

    public List<TimePeriod> breakDownYearly(TimeZone timeZone) {
        if (timeZone == null) {
            throw new NullPointerException("timezone cannot be null");
        }
        Calendar init = Calendar.getInstance(timeZone);
        init.setTime(this.startTime);
        Calendar endCalendar = Calendar.getInstance(timeZone);
        endCalendar.setTime(this.endTime);
        Date end = endCalendar.getTime();
        ArrayList<Date> timePoints = new ArrayList<Date>();
        timePoints.add(init.getTime());
        Calendar next = Calendar.getInstance(timeZone);
        next.set(init.get(1), 0, 1, 0, 0, 0);
        next.set(14, 0);
        next.add(1, 1);
        while (next.getTime().compareTo(end) < 0) {
            timePoints.add(next.getTime());
            next.add(1, 1);
        }
        timePoints.add(end);
        return TimePeriod.generatePeriodsFromPoints(timePoints, timeZone);
    }
}

