/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.persistence.util.common.type;

import com.google.common.base.MoreObjects;
import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import javax.annotation.Nonnull;
import org.opendaylight.persistence.util.common.Converter;
import org.opendaylight.persistence.util.common.type.SortOrder;

public final class Sort<T> {
    private T sortBy;
    private SortOrder sortOrder;

    Sort(@Nonnull T sortBy, @Nonnull SortOrder sortOrder) {
        this.sortBy = Preconditions.checkNotNull(sortBy, (Object)"sortBy");
        this.sortOrder = (SortOrder)((Object)Preconditions.checkNotNull((Object)((Object)sortOrder), (Object)"sortOrder"));
    }

    public static <T> Sort<T> ascending(@Nonnull T sortBy) {
        return new Sort<T>(sortBy, SortOrder.ASCENDING);
    }

    public static <T> Sort<T> descending(@Nonnull T sortBy) {
        return new Sort<T>(sortBy, SortOrder.DESCENDING);
    }

    public T by() {
        return this.sortBy;
    }

    public SortOrder order() {
        return this.sortOrder;
    }

    public <E> Sort<E> convert(Converter<T, E> converter) {
        return new Sort<E>(converter.convert(this.sortBy), this.sortOrder);
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.sortBy, this.sortOrder});
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Sort other = (Sort)obj;
        if (!Objects.equal(this.sortBy, other.sortBy)) {
            return false;
        }
        return this.sortOrder == other.sortOrder;
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("by", this.sortBy).add("order", (Object)this.sortOrder).toString();
    }
}

