/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.persistence.util.common.filter;

import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import java.io.Serializable;
import javax.annotation.Nonnull;

public final class StringCondition
implements Serializable {
    private static final long serialVersionUID = 1L;
    private final String value;
    private final Mode mode;

    private StringCondition(String value, @Nonnull Mode mode) {
        Preconditions.checkNotNull((Object)((Object)mode), (Object)"mode");
        this.value = value;
        this.mode = mode;
    }

    public static StringCondition equalTo(String value) {
        return new StringCondition(value, Mode.EQUAL);
    }

    public static StringCondition unequalTo(String value) {
        return new StringCondition(value, Mode.UNEQUAL);
    }

    public static StringCondition startWith(String value) {
        return new StringCondition(value, Mode.STARTS_WITH);
    }

    public static StringCondition contain(String value) {
        return new StringCondition(value, Mode.CONTAINS);
    }

    public static StringCondition endWith(String value) {
        return new StringCondition(value, Mode.ENDS_WITH);
    }

    public String getValue() {
        return this.value;
    }

    public Mode getMode() {
        return this.mode;
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("value", (Object)this.value).add("mode", (Object)this.mode).toString();
    }

    public static enum Mode {
        EQUAL,
        UNEQUAL,
        STARTS_WITH,
        CONTAINS,
        ENDS_WITH;

    }
}

