/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.persistence.util.common.type.page;

import com.google.common.base.MoreObjects;
import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import org.opendaylight.persistence.util.common.type.page.PageRequest;

public class OffsetPageRequest
extends PageRequest {
    private static final long serialVersionUID = 1L;
    private final long offset;

    public OffsetPageRequest(int size) {
        this(0L, size);
    }

    public OffsetPageRequest(long offset, int size) {
        super(size);
        Preconditions.checkArgument((offset >= 0L ? 1 : 0) != 0, (Object)"offset must be greater or equals to zero");
        this.offset = offset;
    }

    public long getOffset() {
        return this.offset;
    }

    public int getPageIndex() {
        long pageIndex = this.offset / (long)this.getSize();
        if (this.offset % (long)this.getSize() != 0L) {
            ++pageIndex;
        }
        return (int)pageIndex;
    }

    @Override
    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.offset, this.getSize()});
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        OffsetPageRequest other = (OffsetPageRequest)obj;
        if (this.offset != other.offset) {
            return false;
        }
        return this.getSize() == other.getSize();
    }

    @Override
    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("offset", this.offset).add("size", this.getSize()).toString();
    }
}

