/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.persistence.util.common.type;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.opendaylight.persistence.util.common.Converter;
import org.opendaylight.persistence.util.common.type.Sort;
import org.opendaylight.persistence.util.common.type.SortOrder;

public class SortSpecification<T> {
    private List<Sort<T>> components = new ArrayList<Sort<T>>();

    public void addSortComponent(T attribute, SortOrder sortOrder) {
        this.components.add(new Sort<T>(attribute, sortOrder));
    }

    public List<Sort<T>> getSortComponents() {
        return Collections.unmodifiableList(this.components);
    }

    public <D> SortSpecification<D> convert(Converter<T, D> converter) {
        SortSpecification<D> converted = new SortSpecification<D>();
        for (Sort<T> component : this.components) {
            converted.addSortComponent(converter.convert(component.by()), component.order());
        }
        return converted;
    }
}

