/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.persistence.util.common.filter;

import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import java.io.Serializable;
import org.opendaylight.persistence.util.common.Converter;

public final class EqualityCondition<D>
implements Serializable {
    private static final long serialVersionUID = 1L;
    private final D value;
    private final Mode mode;

    private EqualityCondition(D value, Mode mode) {
        this.value = value;
        this.mode = (Mode)((Object)Preconditions.checkNotNull((Object)((Object)mode), (Object)"mode"));
    }

    public static <D> EqualityCondition<D> equalTo(D value) {
        return new EqualityCondition<D>(value, Mode.EQUAL);
    }

    public static <D> EqualityCondition<D> unequalTo(D value) {
        return new EqualityCondition<D>(value, Mode.UNEQUAL);
    }

    public D getValue() {
        return this.value;
    }

    public Mode getMode() {
        return this.mode;
    }

    public <T> EqualityCondition<T> convert(Converter<D, T> converter) throws NullPointerException {
        Preconditions.checkNotNull(converter, (Object)"converter");
        return new EqualityCondition<T>(converter.convert(this.value), this.mode);
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("value", this.value).add("mode", (Object)this.mode).toString();
    }

    public static enum Mode {
        EQUAL,
        UNEQUAL;

    }
}

