/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.persistence.util.common.filter;

import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import java.io.Serializable;
import org.opendaylight.persistence.util.common.Converter;

public final class ComparabilityCondition<D extends Comparable<D>>
implements Serializable {
    private static final long serialVersionUID = 1L;
    private final D value;
    private final Mode mode;

    private ComparabilityCondition(D value, Mode mode) {
        this.value = (Comparable)Preconditions.checkNotNull(value, (Object)"value");
        this.mode = (Mode)((Object)Preconditions.checkNotNull((Object)((Object)mode), (Object)"mode"));
    }

    public static <D extends Comparable<D>> ComparabilityCondition<D> lessThan(D value) {
        return new ComparabilityCondition<D>(value, Mode.LESS_THAN);
    }

    public static <D extends Comparable<D>> ComparabilityCondition<D> lessThanOrEqualTo(D value) {
        return new ComparabilityCondition<D>(value, Mode.LESS_THAN_OR_EQUAL_TO);
    }

    public static <D extends Comparable<D>> ComparabilityCondition<D> equalTo(D value) {
        return new ComparabilityCondition<D>(value, Mode.EQUAL);
    }

    public static <D extends Comparable<D>> ComparabilityCondition<D> greaterThanOrEqualTo(D value) {
        return new ComparabilityCondition<D>(value, Mode.GREATER_THAN_OR_EQUAL_TO);
    }

    public static <D extends Comparable<D>> ComparabilityCondition<D> greaterThan(D value) {
        return new ComparabilityCondition<D>(value, Mode.GREATER_THAN);
    }

    public D getValue() {
        return this.value;
    }

    public Mode getMode() {
        return this.mode;
    }

    public <T extends Comparable<T>> ComparabilityCondition<T> convert(Converter<D, T> converter) {
        Preconditions.checkNotNull(converter, (Object)"converter");
        return new ComparabilityCondition<Comparable>((Comparable)converter.convert(this.value), this.mode);
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("value", this.value).add("mode", (Object)this.mode).toString();
    }

    public static enum Mode {
        LESS_THAN,
        LESS_THAN_OR_EQUAL_TO,
        EQUAL,
        GREATER_THAN_OR_EQUAL_TO,
        GREATER_THAN;

    }
}

